/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.property.PropertySupport;
import com.atlassian.bitbucket.property.SimplePropertySupport;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;

public class InternalDetailedUser
extends SimplePropertySupport
implements DetailedUser {
    private final long createdTimestamp;
    private final InternalApplicationUser delegate;
    private final boolean deletable;
    private final String directoryName;
    private final long lastAuthenticationTimestamp;
    private final boolean mutableDetails;
    private final boolean mutableGroups;

    private InternalDetailedUser(Builder builder) {
        super((SimplePropertySupport.AbstractPropertyBuilder)builder);
        this.createdTimestamp = builder.createdTimestamp == null ? -1L : builder.createdTimestamp.getTime();
        this.delegate = builder.delegate;
        this.deletable = builder.deletable;
        this.directoryName = builder.directoryName;
        this.lastAuthenticationTimestamp = builder.lastAuthenticationTimestamp == null ? -1L : builder.lastAuthenticationTimestamp.getTime();
        this.mutableDetails = builder.mutableDetails;
        this.mutableGroups = builder.mutableGroups;
    }

    public <T> T accept(@Nonnull ApplicationUserVisitor<T> visitor) {
        return (T)visitor.visit((DetailedUser)this);
    }

    public boolean equals(Object o) {
        return ApplicationUserEquality.equals((ApplicationUser)this, (Object)o);
    }

    public InternalApplicationUser getDelegate() {
        return this.delegate;
    }

    @Nullable
    public Date getCreatedTimestamp() {
        return this.createdTimestamp == -1L ? null : new Date(this.createdTimestamp);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    @Nonnull
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String getEmailAddress() {
        return this.delegate.getEmailAddress();
    }

    public int getId() {
        return this.delegate.getId();
    }

    public Date getLastAuthenticationTimestamp() {
        return this.lastAuthenticationTimestamp == -1L ? null : new Date(this.lastAuthenticationTimestamp);
    }

    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }

    @Nonnull
    public String getSlug() {
        return this.delegate.getSlug();
    }

    @Nonnull
    public UserType getType() {
        return this.delegate.getType();
    }

    public int hashCode() {
        return ApplicationUserEquality.hashCode((ApplicationUser)this);
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public boolean isMutableDetails() {
        return this.mutableDetails;
    }

    public boolean isMutableGroups() {
        return this.mutableGroups;
    }

    public static class Builder
    extends SimplePropertySupport.AbstractPropertyBuilder<Builder> {
        private InternalApplicationUser delegate;
        private Date createdTimestamp;
        private boolean deletable;
        private String directoryName;
        private Date lastAuthenticationTimestamp;
        private boolean mutableDetails;
        private boolean mutableGroups;

        public Builder(InternalApplicationUser user) {
            this.delegate = Objects.requireNonNull(user, "user");
        }

        public Builder(InternalDetailedUser user) {
            super((PropertySupport)user);
            this.delegate = Objects.requireNonNull(user, (String)"user").delegate;
            this.directoryName = user.getDirectoryName();
            this.mutableDetails = user.isMutableDetails();
            this.mutableGroups = user.isMutableGroups();
        }

        @Nonnull
        public InternalDetailedUser build() {
            return new InternalDetailedUser(this);
        }

        @Nonnull
        public Builder createdTimestamp(@Nullable Date value) {
            this.createdTimestamp = value;
            return this;
        }

        @Nonnull
        public Builder deletable(boolean value) {
            this.deletable = value;
            return this;
        }

        @Nonnull
        public Builder directoryName(String value) {
            this.directoryName = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder lastAuthenticationTimestamp(@Nullable Date value) {
            this.lastAuthenticationTimestamp = value;
            return this;
        }

        @Nonnull
        public Builder mutableDetails(boolean value) {
            this.mutableDetails = value;
            return this;
        }

        @Nonnull
        public Builder mutableGroups(boolean value) {
            this.mutableGroups = value;
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

