/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.jpa.ZoneIdConverter;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalDetailedUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;

@Entity
@Table(name="sta_normal_user")
@PrimaryKeyJoinColumn(name="user_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_sta_normal_user_id"))
public class InternalNormalUser
extends InternalApplicationUser {
    public static final String TABLE = "sta_normal_user";
    public static final ToInternalNormalUserVisitor TO_NORMAL_USER = new ToInternalNormalUserVisitor();
    public static final int MAX_NAME_LENGTH = 255;
    @Transient
    private volatile transient User backingCrowdUser;
    @Column(name="name", nullable=false, unique=true)
    @RequiredString(size=255)
    private final String username;
    @Column(name="slug", nullable=false, unique=true)
    private final String slug;
    @Column(name="locale", nullable=true)
    private final Locale locale;
    @Column(name="deleted_timestamp", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date deletedDate;
    @Column(name="time_zone", nullable=true, length=64)
    @Convert(converter=ZoneIdConverter.class)
    private final ZoneId timeZone;

    protected InternalNormalUser() {
        this.backingCrowdUser = null;
        this.slug = null;
        this.username = null;
        this.locale = null;
        this.deletedDate = null;
        this.timeZone = null;
    }

    protected InternalNormalUser(@Nonnull Builder builder) {
        super(builder);
        this.slug = builder.slug == null ? InternalNormalUser.slugify(builder.name) : builder.slug;
        this.username = IdentifierUtils.toLowerCase((String)builder.name);
        this.backingCrowdUser = builder.crowdUser;
        this.locale = builder.locale;
        this.deletedDate = builder.deletedDate != null ? new Date(builder.deletedDate.getTime()) : null;
        this.timeZone = builder.timeZone;
    }

    public static Optional<InternalNormalUser> fromUser(@Nullable ApplicationUser applicationUser) {
        return Optional.ofNullable(applicationUser).map(user -> (InternalApplicationUser)user.accept((ApplicationUserVisitor)ToInternalApplicationUser.INSTANCE)).map(internalApplicationUser -> internalApplicationUser.accept(TO_NORMAL_USER));
    }

    @Override
    public <T> T accept(@Nonnull InternalStashUserVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public <T> T accept(@Nonnull ApplicationUserVisitor<T> visitor) {
        return (T)visitor.visit((ApplicationUser)this);
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    public User getBackingCrowdUser() {
        return this.backingCrowdUser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Date getDeletedDate() {
        return this.deletedDate != null ? new Date(this.deletedDate.getTime()) : null;
    }

    @Nonnull
    public String getDisplayName() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getDisplayName() : this.username;
    }

    @Override
    public String getEmailAddress() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getEmailAddress() : super.getEmailAddress();
    }

    @Nonnull
    public String getName() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getName() : this.username;
    }

    @Nonnull
    public String getSlug() {
        return this.slug;
    }

    @Nullable
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    @Nonnull
    public UserType getType() {
        return UserType.NORMAL;
    }

    public boolean isActive() {
        return this.backingCrowdUser != null && this.backingCrowdUser.isActive();
    }

    public boolean isCrowdBacked() {
        return this.backingCrowdUser != null;
    }

    public void setBackingCrowdUser(User crowdUser) {
        Preconditions.checkState((this.backingCrowdUser == null ? 1 : 0) != 0, (Object)"You cannot set the backing Crowd user after it's been initialized");
        this.backingCrowdUser = crowdUser;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.getId()).add("username", (Object)this.username).toString();
    }

    public static class Builder
    extends InternalApplicationUser.AbstractBuilder<Builder, InternalNormalUser> {
        private User crowdUser;
        private Locale locale;
        private Date deletedDate;
        private ZoneId timeZone;

        public Builder() {
        }

        public Builder(InternalNormalUser user) {
            super(user);
            this.crowdUser = user.getBackingCrowdUser();
            this.locale = user.locale;
            this.deletedDate = user.deletedDate;
            this.timeZone = user.timeZone;
        }

        @Override
        @Nonnull
        public InternalNormalUser build() {
            return new InternalNormalUser(this);
        }

        public Builder crowdUser(User value) {
            this.crowdUser = value;
            return this;
        }

        public Builder locale(Locale value) {
            this.locale = value;
            return this;
        }

        public Builder deletedDate(Date value) {
            this.deletedDate = value;
            return this;
        }

        public Builder timeZone(@Nullable ZoneId value) {
            this.timeZone = value;
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }

    public static class ToInternalNormalUserVisitor
    implements InternalStashUserVisitor<InternalNormalUser>,
    Function<InternalApplicationUser, InternalNormalUser> {
        private ToInternalNormalUserVisitor() {
        }

        public InternalNormalUser apply(InternalApplicationUser user) {
            return user.accept(this);
        }

        @Override
        public InternalNormalUser visit(@Nonnull InternalNormalUser user) {
            return user;
        }

        @Override
        public InternalNormalUser visit(@Nonnull InternalServiceUser user) {
            return null;
        }
    }

    private static class ToInternalApplicationUser
    extends AbstractApplicationUserVisitor<InternalApplicationUser> {
        private static final ToInternalApplicationUser INSTANCE = new ToInternalApplicationUser();

        private ToInternalApplicationUser() {
        }

        public InternalApplicationUser visit(@Nonnull DetailedUser user) {
            return ((InternalDetailedUser)user).getDelegate();
        }

        public InternalApplicationUser visit(@Nonnull ApplicationUser user) {
            return user instanceof InternalApplicationUser ? (InternalApplicationUser)user : null;
        }
    }
}

