/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.dmz.user.PermittedPrincipal;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalScopedPermission;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class InternalPermittedPrincipal
implements PermittedPrincipal,
Initializable {
    private final String group;
    private final Permission permission;
    private final InternalApplicationUser user;

    @VisibleForTesting
    public InternalPermittedPrincipal(Permission permission, InternalApplicationUser user, String group) {
        this.permission = Objects.requireNonNull(permission, "permission");
        this.user = user;
        this.group = group;
    }

    public InternalPermittedPrincipal(InternalScopedPermission permission) {
        Objects.requireNonNull(permission, "permission");
        this.permission = permission.getPermission();
        this.user = permission.getUser();
        this.group = permission.getGroup();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalPermittedPrincipal that = (InternalPermittedPrincipal)o;
        return Objects.equals(this.group, that.group) && this.permission == that.permission && Objects.equals(this.user, that.user);
    }

    @Nonnull
    public Optional<String> getGroup() {
        return Optional.ofNullable(this.group);
    }

    @Nonnull
    public Permission getPermission() {
        return this.permission;
    }

    @Nonnull
    public Optional<ApplicationUser> getUser() {
        return Optional.ofNullable(this.user);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.permission, this.user);
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.user);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("permission", (Object)this.permission).add("group", (Object)this.group).add("user", (Object)this.user).toString();
    }
}

