/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.user.InternalScopedPermission;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Index;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;

@Entity
@Table(name="sta_project_permission", indexes={@Index(name="idx_project_permission_user", columnList="user_id"), @Index(name="idx_project_permission_group", columnList="group_name")})
public class InternalProjectPermission
extends InternalScopedPermission {
    static final String TABLE = "sta_project_permission";
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalProject project;

    protected InternalProjectPermission() {
        this.project = null;
    }

    private InternalProjectPermission(Builder builder) {
        super(builder);
        this.project = builder.project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalProjectPermission) {
            InternalProjectPermission that = (InternalProjectPermission)o;
            return Objects.equals(this.getPermission(), that.getPermission()) && Objects.equals(this.getGroup(), that.getGroup()) && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getProject(), that.getProject()) && Objects.equals(this.getUser(), that.getUser());
        }
        return false;
    }

    @Nonnull
    public InternalProject getProject() {
        return this.project;
    }

    @Override
    @Nonnull
    public Scope getScope() {
        return Scopes.project((Project)this.getProject());
    }

    public int hashCode() {
        return Objects.hash(this.getPermission(), this.getGroup(), this.getId(), this.getProject(), this.getUser());
    }

    public static final class Builder
    extends InternalScopedPermission.AbstractBuilder<Builder, InternalProjectPermission> {
        private InternalProject project;

        public Builder() {
        }

        public Builder(@Nonnull InternalProjectPermission permission) {
            super(permission);
            this.project = permission.getProject();
        }

        @Nonnull
        public InternalProjectPermission build() {
            return new InternalProjectPermission(this);
        }

        @Nonnull
        public Builder project(@Nonnull InternalProject project) {
            this.project = Objects.requireNonNull(project, "project");
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

