/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity
@Table(name="repository_access")
@IdClass(value=PK.class)
public class InternalRepositoryAccess
implements Initializable {
    public static final String TABLE = "repository_access";
    @Id
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="user_id", nullable=false)
    private final InternalApplicationUser user;
    @Id
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="repository_id", nullable=false)
    private final InternalRepository repository;
    @Column(name="last_accessed")
    private final long lastAccessed;

    protected InternalRepositoryAccess() {
        this.user = null;
        this.repository = null;
        this.lastAccessed = 0L;
    }

    private InternalRepositoryAccess(InternalApplicationUser user, InternalRepository repository, Date lastAccessed) {
        this.lastAccessed = Objects.requireNonNull(lastAccessed, "lastAccessed must be non-null").getTime();
        this.repository = Objects.requireNonNull(repository, "repository must be non-null");
        this.user = Objects.requireNonNull(user, "user must be non-null");
    }

    @Nonnull
    public Date getLastAccessed() {
        return new Date(this.lastAccessed);
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getRepository());
        Hibernate.initialize((Object)this.getUser());
    }

    public String toString() {
        return "InternalRepositoryAccess[user=" + this.getUser().getUsername() + ",repository=" + this.getRepository().getProject().getKey() + "/" + this.getRepository().getSlug() + ",last_accessed=" + this.lastAccessed + "]";
    }

    public static class PK
    implements Serializable {
        private final Integer repository;
        private final Integer user;

        public PK() {
            this(null, null);
        }

        public PK(Integer user, Integer repository) {
            this.repository = repository;
            this.user = user;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof PK) {
                PK that = (PK)o;
                return Objects.equals(this.user, that.user) && Objects.equals(this.repository, that.repository);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.user, this.repository);
        }
    }

    public static class Builder {
        private Date lastAccessed;
        private InternalRepository repository;
        private InternalApplicationUser user;

        public Builder() {
        }

        public Builder(InternalRepositoryAccess access) {
            this.lastAccessed = Objects.requireNonNull(access, "access").getLastAccessed();
            this.repository = access.getRepository();
            this.user = access.getUser();
        }

        public InternalRepositoryAccess build() {
            return new InternalRepositoryAccess(this.user, this.repository, this.lastAccessed);
        }

        public Builder lastAccessed(Date value) {
            this.lastAccessed = value;
            return this;
        }

        public Builder repository(InternalRepository value) {
            this.repository = value;
            return this;
        }

        public Builder user(InternalApplicationUser value) {
            this.user = value;
            return this;
        }
    }
}

