/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalScopedPermission;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;

@Entity
@Table(name="sta_repo_permission", indexes={@Index(name="idx_repo_permission_user", columnList="user_id"), @Index(name="idx_repo_permission_group", columnList="group_name")})
public class InternalRepositoryPermission
extends InternalScopedPermission {
    static final String TABLE = "sta_repo_permission";
    @JoinColumn(name="repo_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalRepository repository;

    protected InternalRepositoryPermission() {
        this.repository = null;
    }

    private InternalRepositoryPermission(Builder builder) {
        super(builder);
        this.repository = builder.repository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalRepositoryPermission) {
            InternalRepositoryPermission that = (InternalRepositoryPermission)o;
            return Objects.equals(this.getPermission(), that.getPermission()) && Objects.equals(this.getGroup(), that.getGroup()) && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getRepository(), that.getRepository()) && Objects.equals(this.getUser(), that.getUser());
        }
        return false;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    @Nonnull
    public Scope getScope() {
        return Scopes.repository((Repository)this.getRepository());
    }

    public int hashCode() {
        return Objects.hash(this.getPermission(), this.getGroup(), this.getId(), this.getRepository(), this.getUser());
    }

    public static final class Builder
    extends InternalScopedPermission.AbstractBuilder<Builder, InternalRepositoryPermission> {
        private InternalRepository repository;

        public Builder() {
        }

        public Builder(@Nonnull InternalRepositoryPermission permission) {
            super(permission);
            this.repository = permission.getRepository();
        }

        @Nonnull
        public InternalRepositoryPermission build() {
            return new InternalRepositoryPermission(this);
        }

        @Nonnull
        public Builder repository(@Nonnull InternalRepository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

