/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.TableGenerator;
import java.util.Objects;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@TableGenerator(allocationSize=10, pkColumnValue="granted_permission", name="scopedPermissionIdGenerator", table="id_sequence")
public abstract class InternalScopedPermission {
    public static final String ID_GEN = "scopedPermissionIdGenerator";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="scopedPermissionIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="perm_id", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.permission.Permission")})
    private final Permission permission;
    @Column(name="group_name")
    @OptionalString
    private final String group;
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalApplicationUser user;

    protected InternalScopedPermission() {
        this.id = 0L;
        this.permission = null;
        this.group = null;
        this.user = null;
    }

    protected InternalScopedPermission(AbstractBuilder<?, ?> builder) {
        this.id = builder.id;
        this.permission = builder.permission;
        this.group = builder.getGroup();
        this.user = builder.user;
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Nonnull
    public Permission getPermission() {
        return this.permission;
    }

    @Nonnull
    public abstract Scope getScope();

    @Nullable
    public InternalApplicationUser getUser() {
        return this.user;
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B, P>, P extends InternalScopedPermission> {
        private final long id;
        private String group;
        private Permission permission;
        private InternalApplicationUser user;

        protected AbstractBuilder() {
            this.id = 0L;
        }

        protected AbstractBuilder(@Nonnull P permission) {
            Objects.requireNonNull(permission, "permission");
            this.id = ((InternalScopedPermission)permission).getId();
            this.permission = ((InternalScopedPermission)permission).getPermission();
            this.group = ((InternalScopedPermission)permission).getGroup();
            this.user = ((InternalScopedPermission)permission).getUser();
        }

        @Nonnull
        public B group(@Nullable String group) {
            this.group = group;
            return this.self();
        }

        @Nonnull
        public B permission(@Nonnull Permission permission) {
            this.permission = Objects.requireNonNull(permission, "permission");
            return this.self();
        }

        @Nonnull
        public B user(@Nullable InternalApplicationUser user) {
            this.user = user;
            return this.self();
        }

        @Nonnull
        protected abstract B self();

        private String getGroup() {
            return this.group == null ? null : IdentifierUtils.toLowerCase((String)this.group);
        }
    }
}

