/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.stash.internal.user.ResourcePermission;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class SimpleResourcePermission
implements ResourcePermission {
    private final String group;
    private final Permission permission;
    private final Integer projectId;
    private final Integer repositoryId;
    private final Integer repositoryProjectId;
    private final Integer userId;

    public SimpleResourcePermission(String group, @Nonnull Permission permission, Integer projectId, Integer repositoryId, Integer repositoryProjectId) {
        this.permission = Objects.requireNonNull(permission, "permission");
        this.group = group;
        this.projectId = projectId;
        this.repositoryId = repositoryId;
        this.repositoryProjectId = repositoryProjectId;
        this.userId = null;
    }

    public SimpleResourcePermission(@Nonnull Permission permission, Integer projectId, Integer repositoryId, Integer repositoryProjectId, Integer userId) {
        this.group = null;
        this.permission = Objects.requireNonNull(permission, "permission");
        this.projectId = projectId;
        this.repositoryId = repositoryId;
        this.repositoryProjectId = repositoryProjectId;
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleResourcePermission that = (SimpleResourcePermission)o;
        return this.permission == that.permission && (this.group == null ? that.group == null : this.group.equalsIgnoreCase(that.group)) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.repositoryId, that.repositoryId) && Objects.equals(this.repositoryProjectId, that.repositoryProjectId) && Objects.equals(this.userId, that.userId);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    @Nonnull
    public Permission getPermission() {
        return this.permission;
    }

    @Override
    public Integer getProjectId() {
        return this.projectId;
    }

    @Override
    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public Integer getRepositoryProjectId() {
        return this.repositoryProjectId;
    }

    @Override
    public Integer getUserId() {
        return this.userId;
    }

    public int hashCode() {
        return Objects.hash(this.getGroup(), this.getPermission(), this.getProjectId(), this.getRepositoryId(), this.getRepositoryProjectId(), this.getUserId());
    }

    @Override
    public boolean isGlobal() {
        return this.projectId == null && this.repositoryId == null;
    }

    @Override
    public boolean isProject() {
        return this.projectId != null && this.repositoryId == null;
    }

    @Override
    public boolean isRepository() {
        return this.repositoryProjectId != null && this.repositoryId != null;
    }
}

