/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.dmz.user.ScopedPermission;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.InternalRepositoryPermission;
import com.atlassian.stash.internal.user.InternalScopedPermission;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class SimpleScopedPermission
implements ScopedPermission {
    private final String group;
    private final Permission permission;
    private final Project project;
    private final Repository repository;
    private final ApplicationUser user;

    public SimpleScopedPermission(@Nonnull InternalScopedPermission permission) {
        this.permission = Objects.requireNonNull(permission, "permission").getPermission();
        this.group = permission.getGroup();
        this.user = permission.getUser();
        this.project = permission instanceof InternalProjectPermission ? ((InternalProjectPermission)permission).getProject() : null;
        this.repository = permission instanceof InternalRepositoryPermission ? ((InternalRepositoryPermission)permission).getRepository() : null;
    }

    public SimpleScopedPermission(@Nonnull Permission permission, Project project, Repository repository, ApplicationUser user, String group) {
        this.permission = Objects.requireNonNull(permission, "permission");
        this.group = group;
        this.user = user;
        this.project = project;
        this.repository = repository;
    }

    @Nonnull
    public Optional<String> getGroup() {
        return Optional.ofNullable(this.group);
    }

    @Nonnull
    public Permission getPermission() {
        return this.permission;
    }

    @Nonnull
    public Optional<Project> getProject() {
        return Optional.ofNullable(this.project);
    }

    @Nonnull
    public Optional<Repository> getRepository() {
        return Optional.ofNullable(this.repository);
    }

    @Nonnull
    public Optional<ApplicationUser> getUser() {
        return Optional.ofNullable(this.user);
    }
}

