/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.validation;

import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import com.atlassian.stash.internal.validation.UnsupportedInApplicationMode;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;

public class UnsupportedInApplicationModeValidator
implements ConstraintValidator<UnsupportedInApplicationMode, Object> {
    private ApplicationModeSupplier applicationModeSupplier;
    private ApplicationMode[] unsupportedModes;

    public void initialize(UnsupportedInApplicationMode constraintAnnotation) {
        this.unsupportedModes = constraintAnnotation.applicationMode();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        return value == null || Arrays.stream(this.unsupportedModes).noneMatch(mode -> mode == this.applicationModeSupplier.getMode());
    }

    @Autowired
    public void setApplicationModeSupplier(ApplicationModeSupplier applicationModeSupplier) {
        this.applicationModeSupplier = applicationModeSupplier;
    }
}

