/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.watcher;

import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.SimpleWatcher;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

@Cacheable
@Entity
@Table(name="sta_watcher", uniqueConstraints={@UniqueConstraint(name="uq_sta_watchable", columnNames={"watchable_id", "watchable_type", "user_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Immutable
public class InternalWatcherMapping {
    public static final String ID_GEN = "watcherIdGenerator";
    public static final String TABLE = "sta_watcher";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="watcherIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_watcher", name="watcherIdGenerator", table="id_sequence")
    private final long id;
    @JoinColumn(name="user_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_watcher_user"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalApplicationUser user;
    @Column(name="watchable_id")
    private long watchableId;
    @Column(name="watchable_type")
    private int watchableType;

    protected InternalWatcherMapping() {
        this.id = 0L;
        this.user = null;
    }

    private InternalWatcherMapping(@Nonnull Builder builder) {
        this.id = Objects.requireNonNull(builder, (String)"builder").id;
        this.user = builder.user;
        this.watchableId = builder.watchableId;
        this.watchableType = builder.watchableType;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    public long getWatchableId() {
        return this.watchableId;
    }

    public int getWatchableType() {
        return this.watchableType;
    }

    @Nonnull
    public static Set<Watcher> toWatchers(@Nonnull Collection<InternalWatcherMapping> mappings, @Nonnull Watchable watchable) {
        Objects.requireNonNull(mappings, "mappings");
        Objects.requireNonNull(watchable, "watchable");
        return (Set)mappings.stream().map(InternalWatcherMapping::getUser).map(user -> new SimpleWatcher(watchable, (ApplicationUser)user)).collect(MoreCollectors.toImmutableSet());
    }

    public static class Builder {
        private final long id;
        private final InternalApplicationUser user;
        private long watchableId;
        private int watchableType;

        public Builder(@Nonnull InternalWatchable watchable, @Nonnull InternalApplicationUser user) {
            this.id = 0L;
            this.user = Objects.requireNonNull(user, "user");
            Objects.requireNonNull(watchable, "watchable").accept((WatchableVisitor)new WatchableVisitor<Void>(){

                public Void visit(@Nonnull CommitDiscussion discussion) {
                    watchableId = ((InternalCommitDiscussion)discussion).getId();
                    watchableType = 2;
                    return null;
                }

                public Void visit(@Nonnull PullRequest pullRequest) {
                    watchableId = ((InternalPullRequest)pullRequest).getGlobalId();
                    watchableType = 1;
                    return null;
                }

                public Void visit(@Nonnull Repository repository) {
                    watchableId = repository.getId();
                    watchableType = 3;
                    return null;
                }
            });
        }

        @Nonnull
        public InternalWatcherMapping build() {
            return new InternalWatcherMapping(this);
        }
    }
}

