/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal;

import com.atlassian.webhooks.internal.Validator;
import jakarta.annotation.PreDestroy;
import jakarta.validation.ConstraintViolationException;
import java.util.HashSet;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class DefaultValidator
implements Validator {
    private final ServiceTracker<Object, Object> validatorTracker;

    public DefaultValidator(BundleContext bundleContext) {
        this.validatorTracker = new ServiceTracker(bundleContext, "jakarta.validation.Validator", null);
        this.validatorTracker.open();
    }

    @PreDestroy
    public void destroy() {
        this.validatorTracker.close();
    }

    @Override
    public <T> T validate(T target) {
        Object validator = this.validatorTracker.getService();
        if (validator == null) {
            return target;
        }
        HashSet validationErrors = new HashSet(((jakarta.validation.Validator)validator).validate(target, new Class[0]));
        if (!validationErrors.isEmpty()) {
            throw new ConstraintViolationException(validationErrors);
        }
        return target;
    }
}

