/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal;

import com.atlassian.webhooks.WebhookCallback;
import com.atlassian.webhooks.WebhookInvocation;
import com.atlassian.webhooks.request.WebhookHttpRequest;
import com.atlassian.webhooks.request.WebhookHttpResponse;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

class InvocationCompletedCallback
implements WebhookCallback {
    private final AtomicInteger counter;
    private final Runnable callback;

    public InvocationCompletedCallback(int expectedInvocationCount, Runnable callback) {
        this.counter = new AtomicInteger(expectedInvocationCount);
        this.callback = callback;
    }

    public void onError(WebhookHttpRequest request, @Nonnull Throwable error, @Nonnull WebhookInvocation invocation) {
        this.decrementAndCallback();
    }

    public void onFailure(@Nonnull WebhookHttpRequest request, @Nonnull WebhookHttpResponse response, @Nonnull WebhookInvocation invocation) {
        this.decrementAndCallback();
    }

    public void onSuccess(@Nonnull WebhookHttpRequest request, @Nonnull WebhookHttpResponse response, @Nonnull WebhookInvocation invocation) {
        this.decrementAndCallback();
    }

    private void decrementAndCallback() {
        if (this.counter.decrementAndGet() == 0) {
            this.callback.run();
        }
    }
}

