/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlConstructor {
    private static final Pattern URL_VARIABLE_PATTERN = Pattern.compile("(?:%7[Bb]|\\{)([^{}%]+?)(?:%7[Dd]|})");
    public static final String USE_RAW_URLS_FEATURE_FLAG = "plugin.webhooks.use.raw.urls";

    private UrlConstructor() {
    }

    public static String constructUrl(String url, Map<String, Object> urlReplacements, boolean skipUrlReEncoding) {
        StringBuilder result = new StringBuilder();
        Matcher m = URL_VARIABLE_PATTERN.matcher(url);
        while (m.find()) {
            Object replacement = urlReplacements.get(m.group(1));
            if (replacement == null) {
                m.appendReplacement(result, m.group());
                continue;
            }
            m.appendReplacement(result, UrlConstructor.escapeQueryParamValue(String.valueOf(replacement), skipUrlReEncoding));
        }
        m.appendTail(result);
        return result.toString();
    }

    public static String escapeQueryParamValue(String rawParameter, boolean skipUrlReEncoding) {
        if (!skipUrlReEncoding) {
            return rawParameter;
        }
        return URLEncoder.encode(rawParameter, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static String escapeCurlyBraces(String url) {
        return url.replace("{", "%7b").replace("}", "%7d");
    }
}

