/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.configuration;

import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FeatureFlagService {
    private static final String SKIP_URL_REENCODING_FLAG = "plugin.webhooks.skip.url.reencoding";
    private final ApplicationProperties applicationProperties;

    public FeatureFlagService(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Nullable
    @VisibleForTesting
    String getProperty(@Nonnull String key) {
        Objects.requireNonNull(key, "key to get property");
        String systemPropertyValue = System.getProperty(key);
        if (systemPropertyValue != null) {
            return systemPropertyValue;
        }
        try {
            return this.applicationProperties.getPropertyValue(key);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @VisibleForTesting
    boolean getBoolean(@Nonnull String key) {
        Objects.requireNonNull(key, "key to get boolean property");
        return Boolean.parseBoolean(this.getProperty(key));
    }

    public boolean shouldSkipUrlReEncoding() {
        return this.getBoolean(SKIP_URL_REENCODING_FLAG);
    }
}

