/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.dao.ao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.webhooks.internal.dao.ao.v0.WebHookListenerAOV0;
import com.atlassian.webhooks.internal.dao.ao.v1.AoHistoricalInvocationV1;
import com.atlassian.webhooks.internal.dao.ao.v1.AoWebhookConfigurationEntryV1;
import com.atlassian.webhooks.internal.dao.ao.v1.AoWebhookEventV1;
import com.atlassian.webhooks.internal.dao.ao.v1.AoWebhookV1;
import com.atlassian.webhooks.internal.dao.ao.v1.ExternalMigrationTaskInvokerGuard;
import com.atlassian.webhooks.internal.dao.ao.v1.WebhookV1MigrateService;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateToV1Task
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(MigrateToV1Task.class);
    private final WebhookV1MigrateService webhookV1MigrateService;
    private final ExternalMigrationTaskInvokerGuard externalMigrationTaskInvokerService;

    public MigrateToV1Task(WebhookV1MigrateService webhookV1MigrateService, ExternalMigrationTaskInvokerGuard externalMigrationTaskInvokerService) {
        this.webhookV1MigrateService = webhookV1MigrateService;
        this.externalMigrationTaskInvokerService = externalMigrationTaskInvokerService;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"Can only migrate from v0 to v1");
        log.info("Migrating webhooks to version 1");
        ao.migrate(new Class[]{WebHookListenerAOV0.class, AoWebhookV1.class, AoWebhookConfigurationEntryV1.class, AoWebhookEventV1.class, AoHistoricalInvocationV1.class});
        ao.stream(WebHookListenerAOV0.class, hook -> this.webhookV1MigrateService.migrate(ao, (WebHookListenerAOV0)hook));
        this.externalMigrationTaskInvokerService.onMigrationFinished(ao);
        log.info("Migration is complete");
    }
}

