/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.dao.ao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.internal.dao.ao.v0.WebHookListenerAOV0;
import com.atlassian.webhooks.internal.dao.ao.v1.AoWebhookConfigurationEntryV1;
import com.atlassian.webhooks.internal.dao.ao.v1.AoWebhookEventV1;
import com.atlassian.webhooks.internal.dao.ao.v1.AoWebhookV1;
import com.atlassian.webhooks.migration.WebhookDTO;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WebhookV1MigrateService {
    private static final Logger log = LoggerFactory.getLogger(WebhookV1MigrateService.class);

    public void migrate(ActiveObjects ao, WebHookListenerAOV0 webHookListenerAOV0) {
        this.migrate(ao, this.convert(webHookListenerAOV0));
    }

    public int migrate(ActiveObjects ao, WebhookDTO webhookDTO) {
        Date now = new Date();
        ImmutableMap hook = ImmutableMap.builder().put((Object)"CREATED", (Object)now).put((Object)"UPDATED", (Object)now).put((Object)"URL", (Object)webhookDTO.getUrl()).put((Object)"NAME", (Object)webhookDTO.getName()).put((Object)"ACTIVE", (Object)webhookDTO.isEnabled()).put((Object)"SCOPE_TYPE", (Object)WebhookScope.GLOBAL.getType()).build();
        AoWebhookV1 aoWebhook = (AoWebhookV1)ao.create(AoWebhookV1.class, (Map)hook);
        this.createConfiguration(webhookDTO).forEach((key, value) -> ao.create(AoWebhookConfigurationEntryV1.class, (Map)ImmutableMap.of((Object)"KEY", (Object)key, (Object)"WEBHOOKID", (Object)aoWebhook.getID(), (Object)"VALUE", (Object)value)));
        this.getEventsFor(webhookDTO).forEach(event -> ao.create(AoWebhookEventV1.class, (Map)ImmutableMap.of((Object)"EVENT_ID", (Object)event.getId(), (Object)"WEBHOOKID", (Object)aoWebhook.getID())));
        return aoWebhook.getID();
    }

    private WebhookDTO convert(WebHookListenerAOV0 webHookListenerAOV0) {
        return WebhookDTO.builder().url(webHookListenerAOV0.getUrl()).name(webHookListenerAOV0.getName()).description(webHookListenerAOV0.getDescription()).lastUpdated(webHookListenerAOV0.getLastUpdated()).lastUpdatedUser(webHookListenerAOV0.getLastUpdatedUser()).filters(webHookListenerAOV0.getFilters()).registrationMethod(webHookListenerAOV0.getRegistrationMethod()).enabled(webHookListenerAOV0.isEnabled()).excludeBody(webHookListenerAOV0.isExcludeBody()).parameters(webHookListenerAOV0.getParameters()).jsonEvents(webHookListenerAOV0.getEvents()).createWebhookDTO();
    }

    private Map<String, String> createConfiguration(WebhookDTO webhookDTO) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (StringUtils.isNotEmpty((CharSequence)webhookDTO.getFilters())) {
            builder.put((Object)"FILTERS", (Object)webhookDTO.getFilters());
        }
        if (StringUtils.isNotEmpty((CharSequence)webhookDTO.getRegistrationMethod())) {
            builder.put((Object)"REGISTRATION_METHOD", (Object)webhookDTO.getRegistrationMethod());
        }
        if (StringUtils.isNotEmpty((CharSequence)webhookDTO.getParameters())) {
            builder.put((Object)"PARAMETERS", (Object)webhookDTO.getParameters());
        }
        if (StringUtils.isNotEmpty((CharSequence)webhookDTO.getDescription())) {
            builder.put((Object)"DESCRIPTION", (Object)webhookDTO.getDescription());
        }
        if (StringUtils.isNotEmpty((CharSequence)webhookDTO.getLastUpdatedUser())) {
            builder.put((Object)"LAST_UPDATED_USER", (Object)webhookDTO.getLastUpdatedUser());
        }
        if (webhookDTO.getLastUpdated() != null) {
            builder.put((Object)"LAST_UPDATED", (Object)webhookDTO.getLastUpdated().toInstant().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
        builder.put((Object)"EXCLUDE_BODY", (Object)Boolean.toString(webhookDTO.isExcludeBody()));
        return builder.build();
    }

    private Iterable<WebhookEvent> getEventsFor(WebhookDTO webhookDTO) {
        if (StringUtils.isEmpty((CharSequence)webhookDTO.getJsonEvents()) && StringUtils.isEmpty((CharSequence)webhookDTO.getEvents())) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!StringUtils.isEmpty((CharSequence)webhookDTO.getJsonEvents())) {
            try {
                JSONArray jsonArray = new JSONArray(webhookDTO.getJsonEvents());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String event = jsonArray.getString(i);
                    builder.add((Object)new MigrateWebhookEvent(event));
                }
            }
            catch (JSONException e) {
                log.warn("A webhook was unable to migrate the events for id:[{}]", (Object)webhookDTO.getId());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)webhookDTO.getEvents())) {
            for (String event : webhookDTO.getEvents().split("\n")) {
                builder.add((Object)new MigrateWebhookEvent(event));
            }
        }
        return builder.build();
    }

    private static class MigrateWebhookEvent
    implements WebhookEvent {
        private final String id;

        MigrateWebhookEvent(String id) {
            this.id = id;
        }

        @Nonnull
        public String getId() {
            return this.id;
        }

        @Nonnull
        public String getI18nKey() {
            return this.id;
        }
    }
}

