/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.dao.ao.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.webhooks.internal.dao.ao.AoWebhook;
import com.atlassian.webhooks.internal.dao.ao.v1.AoHistoricalInvocationV1;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateToV2Task
implements ActiveObjectsUpgradeTask {
    private static final int PAGE_SIZE = 500;
    private static final Logger log = LoggerFactory.getLogger(MigrateToV2Task.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"1")), (Object)"Can only migrate from v1 to v2");
        log.info("Migrating webhooks to version 2");
        ao.migrate(new Class[]{AoWebhook.class, AoHistoricalInvocationV1toV2.class});
        this.addScopeToInvocations(ao);
        log.info("Migration is complete");
    }

    private void addScopeToInvocations(ActiveObjects ao) {
        boolean fullPageRetrieved;
        while (fullPageRetrieved = ((Boolean)ao.executeInTransaction(() -> {
            AoHistoricalInvocationV1toV2[] invocations;
            String whereClause = "EVENT_SCOPE_TYPE IS NULL AND EVENT_SCOPE_ID IS NULL";
            Query query = Query.select().where(whereClause, new Object[0]).order("ID ASC").limit(500);
            for (AoHistoricalInvocationV1toV2 invocation : invocations = (AoHistoricalInvocationV1toV2[])ao.find(AoHistoricalInvocationV1toV2.class, query)) {
                AoWebhook aoWebhook = (AoWebhook)ao.get(AoWebhook.class, (Object)invocation.getWebhookId());
                if (aoWebhook != null) {
                    String scopeId = aoWebhook.getScopeId() == null ? "" : aoWebhook.getScopeId();
                    invocation.setEventScopeId(scopeId);
                    invocation.setEventScopeType(aoWebhook.getScopeType());
                    invocation.save();
                    continue;
                }
                ao.delete(new RawEntity[]{invocation});
            }
            return invocations.length == 500;
        })).booleanValue()) {
        }
    }

    @Table(value="HIST_INVOCATION")
    @Preload
    public static interface AoHistoricalInvocationV1toV2
    extends AoHistoricalInvocationV1 {
        public static final String COLUMN_EVENT_SCOPE_ID = "EVENT_SCOPE_ID";
        public static final String COLUMN_EVENT_SCOPE_TYPE = "EVENT_SCOPE_TYPE";

        @Accessor(value="EVENT_SCOPE_ID")
        public String getEventScopeId();

        @Accessor(value="EVENT_SCOPE_TYPE")
        public String getEventScopeType();

        @Mutator(value="EVENT_SCOPE_ID")
        public void setEventScopeId(@Nonnull String var1);

        @Mutator(value="EVENT_SCOPE_TYPE")
        public void setEventScopeType(@Nonnull String var1);
    }
}

