/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.internal.history;

import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.history.HistoricalInvocation;
import com.atlassian.webhooks.history.InvocationRequest;
import com.atlassian.webhooks.history.InvocationResult;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleHistoricalInvocation
implements HistoricalInvocation {
    private final WebhookEvent event;
    private final WebhookScope eventScope;
    private final Instant finish;
    private final InvocationRequest request;
    private final InvocationResult result;
    private final Instant start;
    private final String id;

    protected SimpleHistoricalInvocation(@Nonnull String id, @Nonnull WebhookEvent event, @Nullable WebhookScope eventScope, @Nonnull Instant start, @Nonnull Instant finish, @Nonnull InvocationRequest request, @Nonnull InvocationResult result) {
        this.id = Objects.requireNonNull(id, "id");
        this.event = Objects.requireNonNull(event, "event");
        this.eventScope = eventScope;
        this.finish = Objects.requireNonNull(finish, "finish");
        this.request = Objects.requireNonNull(request, "request");
        this.result = Objects.requireNonNull(result, "result");
        this.start = Objects.requireNonNull(start, "start");
    }

    @Nonnull
    public Duration getDuration() {
        return Duration.between(this.start, this.finish);
    }

    @Nonnull
    public WebhookEvent getEvent() {
        return this.event;
    }

    @Nonnull
    public Optional<WebhookScope> getEventScope() {
        return Optional.ofNullable(this.eventScope);
    }

    @Nonnull
    public Instant getFinish() {
        return this.finish;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public InvocationRequest getRequest() {
        return this.request;
    }

    @Nonnull
    public InvocationResult getResult() {
        return this.result;
    }

    @Nonnull
    public Instant getStart() {
        return this.start;
    }
}

