/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.dmz.auditing.DmzLegacyAuditEventsHelper;
import com.atlassian.bitbucket.internal.audit.dao.AoProjectAuditEvent;
import com.atlassian.bitbucket.internal.audit.dao.AoRepositoryAuditEvent;
import com.atlassian.bitbucket.internal.audit.dao.DaoAuditEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.AuditUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class AoAuditEventToAuditEntityMapper {
    private static final String ATTRIBUTE_NAME_DETAILS = "bitbucket.audit.attribute.legacy.details";
    private static final String NON_EXISTING_KEY = "-";
    private static final int USER_CACHE_INITIAL_CAPACITY = 1000;
    private static final int USER_CACHE_MAXIMUM_SIZE = 10000;
    private final DmzLegacyAuditEventsHelper legacyAuditEventsHelper;
    private final AtomicReference<Project> projectCache;
    private final ProjectService projectService;
    private final AtomicReference<Repository> repositoryCache;
    private final RepositoryService repositoryService;
    private final Cache<Integer, Optional<ApplicationUser>> userCache;
    private final UserService userService;

    public AoAuditEventToAuditEntityMapper(DmzLegacyAuditEventsHelper legacyAuditEventsHelper, ProjectService projectService, RepositoryService repositoryService, UserService userService) {
        this.legacyAuditEventsHelper = Objects.requireNonNull(legacyAuditEventsHelper, "legacyAuditEventsHelper");
        this.projectService = Objects.requireNonNull(projectService, "projectService");
        this.repositoryService = Objects.requireNonNull(repositoryService, "repositoryService");
        this.userService = Objects.requireNonNull(userService);
        this.projectCache = new AtomicReference();
        this.repositoryCache = new AtomicReference();
        this.userCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(10000L).build();
    }

    public AuditEntity toAuditEntity(DaoAuditEvent event) {
        return this.toAoAuditEntity(event, this.getAffectedObject(event));
    }

    private AuditEntity toAoAuditEntity(DaoAuditEvent event, AuditResource affectedObject) {
        AuditEntity.Builder auditEntityBuilder = new AuditEntity.Builder(this.legacyAuditEventsHelper.auditTypeFor(event.getAction())).affectedObject(affectedObject).timestamp(event.getTimestamp().toInstant());
        this.getUser(event.getUserId()).ifPresent(user -> auditEntityBuilder.author(AuditUtils.auditAuthorForUser((ApplicationUser)user)));
        if (StringUtils.isNotBlank((CharSequence)event.getDetails())) {
            auditEntityBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTRIBUTE_NAME_DETAILS, (String)event.getDetails()).withNameTranslation(ATTRIBUTE_NAME_DETAILS).build());
        }
        return auditEntityBuilder.build();
    }

    private AuditResource getAffectedObject(DaoAuditEvent event) {
        return event instanceof AoProjectAuditEvent ? this.getProjectResource((AoProjectAuditEvent)event) : this.getRepositoryResource((AoRepositoryAuditEvent)event);
    }

    private AuditResource getProjectResource(AoProjectAuditEvent event) {
        Integer projectId = event.getProjectId();
        return this.getProject(projectId).map(AuditUtils::auditResourceForProject).orElse(AuditResource.builder((String)NON_EXISTING_KEY, (String)"PROJECT").id(String.valueOf(projectId)).build());
    }

    private AuditResource getRepositoryResource(AoRepositoryAuditEvent event) {
        Integer repositoryId = event.getRepositoryId();
        return this.getRepository(repositoryId).map(AuditUtils::auditResourceForRepository).orElse(AuditResource.builder((String)NON_EXISTING_KEY, (String)"REPOSITORY").id(String.valueOf(repositoryId)).build());
    }

    private Optional<Project> getProject(int id) {
        return Optional.ofNullable(this.projectCache.updateAndGet(project -> {
            if (project != null && project.getId() == id) {
                return project;
            }
            return this.projectService.getById(id);
        }));
    }

    private Optional<Repository> getRepository(int id) {
        return Optional.ofNullable(this.repositoryCache.updateAndGet(repository -> {
            if (repository != null && repository.getId() == id) {
                return repository;
            }
            return this.repositoryService.getById(id);
        }));
    }

    private Optional<ApplicationUser> getUser(Integer userId) {
        if (userId == null) {
            return Optional.empty();
        }
        try {
            return (Optional)this.userCache.get((Object)userId, () -> {
                ApplicationUser applicationUser = this.userService.getUserById(userId.intValue(), true);
                return Optional.ofNullable(applicationUser);
            });
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }
}

