/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.spi.migration.LegacyAuditEntityMigrator;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.audit.AoAuditEventToAuditEntityMapper;
import com.atlassian.bitbucket.internal.audit.AoAuditEventToAuditEntityMapperFactory;
import com.atlassian.bitbucket.internal.audit.AuditMigrationTracker;
import com.atlassian.bitbucket.internal.audit.dao.AoProjectAuditEvent;
import com.atlassian.bitbucket.internal.audit.dao.AoRepositoryAuditEvent;
import com.atlassian.bitbucket.internal.audit.dao.DaoAuditEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import net.java.ao.Query;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoAuditEventToAuditEntityMigrator
implements LegacyAuditEntityMigrator {
    private static final Logger log = LoggerFactory.getLogger(AoAuditEventToAuditEntityMigrator.class);
    private static final int MAX_RETRIES = 5;
    private final ActiveObjects activeObjects;
    private final AoAuditEventToAuditEntityMapperFactory auditEntityMapperFactory;
    private final AuditMigrationTracker auditMigrationTracker;
    private final int eventsPageSize;
    private final ExecutorService executorService;
    private final ProjectHelper projectHelper;
    private final RepositoryHelper repositoryHelper;
    private final SecurityService securityService;

    public AoAuditEventToAuditEntityMigrator(ActiveObjects activeObjects, AoAuditEventToAuditEntityMapperFactory aoAuditEventToAuditEntityMapperFactory, AuditMigrationTracker auditMigrationTracker, SecurityService securityService, ExecutorService executorService) {
        this.activeObjects = activeObjects;
        this.auditEntityMapperFactory = aoAuditEventToAuditEntityMapperFactory;
        this.auditMigrationTracker = auditMigrationTracker;
        this.securityService = securityService;
        this.executorService = executorService;
        this.eventsPageSize = 1000;
        this.projectHelper = new ProjectHelper(activeObjects);
        this.repositoryHelper = new RepositoryHelper(activeObjects);
    }

    public void migrate(@Nonnull AuditConsumer auditConsumer) {
        Objects.requireNonNull(auditConsumer, "auditConsumer");
        if (this.activeObjects.count(AoProjectAuditEvent.class) == 0 && this.activeObjects.count(AoRepositoryAuditEvent.class) == 0) {
            return;
        }
        this.auditMigrationTracker.migrationTriggered();
        AoAuditEventToAuditEntityMapper aoAuditEventToAuditEntityMapper = this.auditEntityMapperFactory.create();
        this.executorService.submit(() -> this.securityService.withPermission(Permission.ADMIN, "Migration of Project Audit events").call(() -> {
            this.migrateWithRetries(aoAuditEventToAuditEntityMapper, auditConsumer, this.projectHelper);
            return null;
        }));
        this.executorService.submit(() -> this.securityService.withPermission(Permission.ADMIN, "Migration of Repository Audit events").call(() -> {
            this.migrateWithRetries(aoAuditEventToAuditEntityMapper, auditConsumer, this.repositoryHelper);
            return null;
        }));
    }

    private <T extends DaoAuditEvent> void migrateWithRetries(AoAuditEventToAuditEntityMapper aoAuditEventToAuditEntityMapper, AuditConsumer auditConsumer, ExistingDataHelper<T> existingDataHelper) {
        int noOfAttempts = 0;
        boolean complete = false;
        do {
            try (Timer ignored = TimerUtils.start((String)("Audit: " + existingDataHelper.getLogIdentifier() + " events migration"));){
                log.info("Attempt {} : Starting {} audit events migration", (Object)(++noOfAttempts), (Object)existingDataHelper.getLogIdentifier());
                int migratedCount = this.migrate(aoAuditEventToAuditEntityMapper, auditConsumer, existingDataHelper);
                complete = true;
                log.info("Attempt {} : Finished migration of {} {} audit events", new Object[]{noOfAttempts, migratedCount, existingDataHelper.getLogIdentifier()});
            }
            catch (Exception e) {
                log.error("Attempt {} : Error occurred during migration of {} audit events", new Object[]{noOfAttempts, existingDataHelper.getLogIdentifier(), e});
            }
        } while (!complete && noOfAttempts < 5);
    }

    private <T extends DaoAuditEvent> int migrate(AoAuditEventToAuditEntityMapper aoAuditEventToAuditEntityMapper, AuditConsumer auditConsumer, ExistingDataHelper<T> existingDataHelper) {
        boolean isLastPage;
        PageRequest firstPageRequest = PageUtils.newRequest((int)0, (int)this.eventsPageSize);
        PageProvider pageProvider = existingDataHelper.pageProvider();
        MutableObject migratedCount = new MutableObject((Object)0);
        while (!(isLastPage = ((Boolean)this.activeObjects.executeInTransaction(() -> {
            Page events = pageProvider.get(firstPageRequest);
            Page auditEntities = events.transform(aoAuditEventToAuditEntityMapper::toAuditEntity);
            if (auditEntities.getValues().iterator().hasNext()) {
                auditConsumer.accept((List)ImmutableList.copyOf((Iterable)auditEntities.getValues()));
                migratedCount.setValue((Object)((Integer)migratedCount.getValue() + existingDataHelper.delete(events)));
            }
            return events.getIsLastPage();
        })).booleanValue())) {
        }
        return (Integer)migratedCount.getValue();
    }

    private static class ProjectHelper
    extends ExistingDataHelper<AoProjectAuditEvent> {
        public ProjectHelper(ActiveObjects activeObjects) {
            super(AoProjectAuditEvent.class, activeObjects);
        }

        @Override
        String getResourceIdColumn() {
            return "PROJECT_ID";
        }

        @Override
        int getResourceId(AoProjectAuditEvent event) {
            return event.getProjectId();
        }

        @Override
        String getLogIdentifier() {
            return "project";
        }
    }

    private static class RepositoryHelper
    extends ExistingDataHelper<AoRepositoryAuditEvent> {
        public RepositoryHelper(ActiveObjects activeObjects) {
            super(AoRepositoryAuditEvent.class, activeObjects);
        }

        @Override
        String getResourceIdColumn() {
            return "REPOSITORY_ID";
        }

        @Override
        int getResourceId(AoRepositoryAuditEvent event) {
            return event.getRepositoryId();
        }

        @Override
        String getLogIdentifier() {
            return "repository";
        }
    }

    private static abstract class ExistingDataHelper<T extends DaoAuditEvent> {
        private final Class<T> entityClass;
        private final ActiveObjects activeObjects;

        public ExistingDataHelper(Class<T> entityClass, ActiveObjects activeObjects) {
            this.entityClass = entityClass;
            this.activeObjects = activeObjects;
        }

        private synchronized PageProvider<T> pageProvider() {
            return pageRequest -> {
                Query paginatedQuery = AoUtils.restrict((Query)Query.select().order(this.getResourceIdColumn() + ",AUDIT_ITEM_ID"), (PageRequest)pageRequest);
                Object[] entities = (DaoAuditEvent[])this.activeObjects.find(this.entityClass, paginatedQuery);
                return PageUtils.createPage((Iterable)ImmutableList.copyOf((Object[])entities), (PageRequest)pageRequest);
            };
        }

        private synchronized int delete(Page<T> page) {
            DaoAuditEvent last = Objects.requireNonNull((DaoAuditEvent)Iterables.getLast((Iterable)page.getValues(), null));
            int maxResourceId = this.getResourceId(last);
            int id = last.getId();
            return this.activeObjects.deleteWithSQL(this.entityClass, String.format("%s < ? OR (%s = ? AND %s <= ?)", this.getResourceIdColumn(), this.getResourceIdColumn(), "AUDIT_ITEM_ID"), new Object[]{maxResourceId, maxResourceId, id});
        }

        abstract String getResourceIdColumn();

        abstract int getResourceId(T var1);

        abstract String getLogIdentifier();
    }
}

