/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.annotations.VisibleForTesting;

public class AuditMigrationTracker {
    @VisibleForTesting
    static final String MIGRATION_TRIGGERED_KEY = "com.atlassian.bitbucket.audit:migration.triggered";
    private final PluginSettings pluginSettings;

    public AuditMigrationTracker(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public boolean isMigrationTriggered() {
        Object migrationState = this.pluginSettings.get(MIGRATION_TRIGGERED_KEY);
        if (migrationState == null) {
            this.pluginSettings.put(MIGRATION_TRIGGERED_KEY, (Object)String.valueOf(false));
            return false;
        }
        return Boolean.parseBoolean(migrationState.toString());
    }

    public void migrationTriggered() {
        if (!this.isMigrationTriggered()) {
            this.pluginSettings.put(MIGRATION_TRIGGERED_KEY, (Object)String.valueOf(true));
        }
    }
}

