/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit;

import com.atlassian.audit.api.events.AuditRetentionConfigUpdatedEvent;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.audit.AuditMigrationTracker;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;

public class RetentionConfigReviewNotificationService {
    @VisibleForTesting
    static final String RETENTION_CONFIG_REVIEW_NOTIFICATION_KEY = "com.atlassian.bitbucket.audit:retention-config-review-notification";
    private final AuditMigrationTracker auditMigrationTracker;
    private final AuthenticationContext authenticationContext;
    private final PermissionValidationService permissionValidationService;
    private final PluginSettings pluginSettings;
    private final UserSettingsService userSettingsService;

    public RetentionConfigReviewNotificationService(AuditMigrationTracker auditMigrationTracker, AuthenticationContext authenticationContext, PermissionValidationService permissionValidationService, PluginSettingsFactory pluginSettingsFactory, UserSettingsService userSettingsService) {
        this.auditMigrationTracker = auditMigrationTracker;
        this.authenticationContext = authenticationContext;
        this.permissionValidationService = permissionValidationService;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.userSettingsService = userSettingsService;
    }

    public void dismissNotificationForCurrentUser() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        Optional.ofNullable(this.authenticationContext.getCurrentUser()).ifPresent(this::dismissNotificationForUser);
    }

    @EventListener
    public void onRetentionConfigUpdatedEvent(AuditRetentionConfigUpdatedEvent ignored) {
        if (this.authenticationContext.getCurrentUser() != null) {
            this.dismissNotificationForApplication();
        }
    }

    public boolean shouldDisplayForCurrentUser() {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        return currentUser != null && this.auditMigrationTracker.isMigrationTriggered() && this.isNotificationEnabledForApplication() && this.isNotificationEnabledForUser(currentUser);
    }

    private void dismissNotificationForApplication() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        this.pluginSettings.put(RETENTION_CONFIG_REVIEW_NOTIFICATION_KEY, (Object)String.valueOf(false));
    }

    private void dismissNotificationForUser(ApplicationUser user) {
        this.userSettingsService.updateUserSettings(new UserKey(String.valueOf(user.getId())), builder -> Objects.requireNonNull(builder, "builder").put(RETENTION_CONFIG_REVIEW_NOTIFICATION_KEY, false).build());
    }

    private boolean isNotificationEnabledForApplication() {
        return Optional.ofNullable((String)this.pluginSettings.get(RETENTION_CONFIG_REVIEW_NOTIFICATION_KEY)).map(Boolean::parseBoolean).orElse(true);
    }

    private boolean isNotificationEnabledForUser(ApplicationUser user) {
        return (Boolean)this.userSettingsService.getUserSettings(new UserKey(String.valueOf(user.getId()))).getBoolean(RETENTION_CONFIG_REVIEW_NOTIFICATION_KEY).getOrElse((Object)true);
    }
}

