/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.pagination;

import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.api.util.pagination.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AuditPaginationUtils {
    private AuditPaginationUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static <S, T, C> Page<T, C> toAuditingPage(@Nonnull com.atlassian.bitbucket.util.Page<S> bitbucketPage, @Nonnull Function<S, T> elementConverter) {
        Objects.requireNonNull(bitbucketPage, "bitbucketPage");
        Objects.requireNonNull(elementConverter, "elementConverter");
        List pageElements = bitbucketPage.stream().map(elementConverter).collect(Collectors.toList());
        com.atlassian.bitbucket.util.PageRequest nextPageRequest = bitbucketPage.getNextPageRequest();
        return new Page.Builder(pageElements, bitbucketPage.getIsLastPage()).nextPageRequest(nextPageRequest == null ? null : AuditPaginationUtils.toAuditingPageRequest(nextPageRequest)).build();
    }

    @Nonnull
    public static com.atlassian.bitbucket.util.PageRequest toBitbucketPageRequest(@Nonnull PageRequest<?> auditingPageRequest) {
        Objects.requireNonNull(auditingPageRequest, "auditingPageRequest");
        if (auditingPageRequest.getCursor().isPresent()) {
            throw new UnsupportedOperationException("Cursor is not supported in Bitbucket PageRequest");
        }
        return new PageRequestImpl(auditingPageRequest.getOffset(), auditingPageRequest.getLimit());
    }

    private static <C> PageRequest<C> toAuditingPageRequest(@Nonnull com.atlassian.bitbucket.util.PageRequest bitbucketPageRequest) {
        Objects.requireNonNull(bitbucketPageRequest, "bitbucketPageRequest");
        return new PageRequest.Builder().offset(bitbucketPageRequest.getStart()).limit(bitbucketPageRequest.getLimit()).build();
    }
}

