/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.audit.RetentionConfigReviewNotificationService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="/notification-settings")
@Tag(name="System Maintenance")
public class AuditNotificationSettingsResource {
    private final RetentionConfigReviewNotificationService retentionConfigReviewNotificationService;

    @Inject
    public AuditNotificationSettingsResource(RetentionConfigReviewNotificationService retentionConfigReviewNotificationService) {
        this.retentionConfigReviewNotificationService = retentionConfigReviewNotificationService;
    }

    @Operation(description="Dismisses the retention config review notification displayed by the audit plugin for the user that's currently logged in.", summary="Dismiss retention config notification")
    @ResponseDocs(value={@ResponseDoc(documentation="A blank response", responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to dismiss the notification.", responseCode=401, restError=true)})
    @DELETE
    @Path(value="/retention-config-review")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response dismissRetentionConfigReviewNotification() {
        this.retentionConfigReviewNotificationService.dismissNotificationForCurrentUser();
        return Response.ok().build();
    }
}

