/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.spi.impl;

import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.api.util.pagination.PageRequest;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.spi.lookup.AuditingResourcesLookupService;
import com.atlassian.bitbucket.internal.audit.pagination.AuditPaginationUtils;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AuditResourceSearchServiceProvider;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class DefaultAuditingResourcesLookupService
implements AuditingResourcesLookupService {
    private final AuditResourceSearchServiceProvider auditResourceSearchServiceProvider;
    private final UserService userService;

    public DefaultAuditingResourcesLookupService(AuditResourceSearchServiceProvider auditResourceSearchServiceProvider, UserService userService) {
        this.auditResourceSearchServiceProvider = auditResourceSearchServiceProvider;
        this.userService = userService;
    }

    @Nonnull
    public Page<AuditAuthor, String> lookupAuditAuthor(@Nullable String searchText, @Nonnull PageRequest<String> pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        com.atlassian.bitbucket.util.Page users = this.userService.findUsersByName(searchText, AuditPaginationUtils.toBitbucketPageRequest(pageRequest));
        return AuditPaginationUtils.toAuditingPage(users, DefaultAuditingResourcesLookupService::toAuditAuthor);
    }

    public Page<AuditResource, String> lookupAuditResource(@Nonnull String resourceType, @Nullable String searchText, @Nonnull PageRequest<String> pageRequest) {
        Objects.requireNonNull(resourceType, "resourceType");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return this.auditResourceSearchServiceProvider.get(resourceType).search(searchText, pageRequest);
    }

    private static AuditAuthor toAuditAuthor(ApplicationUser user) {
        return new AuditAuthor.Builder().id(String.valueOf(user.getId())).name(user.getDisplayName()).type(user.getType().name()).build();
    }
}

