/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.spi.impl.enrichment;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditAuthorEnricher {
    private static final Logger log = LoggerFactory.getLogger(AuditAuthorEnricher.class);
    private final NavBuilder navBuilder;
    private final UserService userService;

    public AuditAuthorEnricher(NavBuilder navBuilder, UserService userService) {
        this.navBuilder = navBuilder;
        this.userService = userService;
    }

    @Nonnull
    public AuditAuthor enrich(@Nonnull AuditAuthor auditAuthor) {
        Objects.requireNonNull(auditAuthor, "auditAuthor");
        try {
            if (StringUtils.isNumeric((CharSequence)auditAuthor.getId())) {
                ApplicationUser user = this.userService.getUserById(Integer.parseInt(auditAuthor.getId()));
                if (user == null || user.getType() != UserType.NORMAL) {
                    return auditAuthor;
                }
                String uri = this.navBuilder.user(user).buildAbsolute();
                return new AuditAuthor.Builder(auditAuthor).uri(uri).build();
            }
        }
        catch (RuntimeException e) {
            log.error("Failed to enrich AuditAuthor : {}", (Object)auditAuthor, (Object)e);
        }
        return auditAuthor;
    }
}

