/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.spi.impl.enrichment;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.spi.entity.AuditEntityTransformationService;
import com.atlassian.bitbucket.internal.audit.spi.impl.enrichment.AuditAuthorEnricher;
import com.atlassian.bitbucket.internal.audit.spi.impl.enrichment.AuditResourceEnricher;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AuditEntityEnrichmentService
implements AuditEntityTransformationService {
    private final AuditAuthorEnricher auditAuthorEnricher;
    private final AuditResourceEnricher auditResourceEnricher;

    public AuditEntityEnrichmentService(AuditAuthorEnricher auditAuthorEnricher, AuditResourceEnricher auditResourceEnricher) {
        this.auditAuthorEnricher = auditAuthorEnricher;
        this.auditResourceEnricher = auditResourceEnricher;
    }

    @Nonnull
    public List<AuditEntity> transform(@Nonnull List<AuditEntity> entities) {
        Objects.requireNonNull(entities, "entities");
        return entities.stream().map(entity -> new AuditEntity.Builder(entity).affectedObjects(entity.getAffectedObjects().stream().map(this.auditResourceEnricher::enrich).collect(Collectors.toList())).author(this.auditAuthorEnricher.enrich(entity.getAuthor())).build()).collect(Collectors.toList());
    }
}

