/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.spi.impl.enrichment;

import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AppLinkAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AuditableResourceMapper;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AuditableResourceVisitor;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.CommitAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.GroupAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.ProjectAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.PullRequestAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.RepositoryAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.UnknownAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.UserAuditableResource;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditResourceEnricher {
    private static final Logger log = LoggerFactory.getLogger(AuditResourceEnricher.class);
    private final AuditableResourceMapper auditableResourceMapper;
    private final ResourceLinkProvider resourceLinkProvider;

    public AuditResourceEnricher(AuditableResourceMapper auditableResourceMapper, NavBuilder navBuilder, PermissionService permissionService, ProjectService projectService, PullRequestService pullRequestService, RepositoryService repositoryService, UserService userService) {
        this.auditableResourceMapper = auditableResourceMapper;
        this.resourceLinkProvider = new ResourceLinkProvider(navBuilder, permissionService, projectService, pullRequestService, repositoryService, userService);
    }

    @Nonnull
    public AuditResource enrich(@Nonnull AuditResource auditResource) {
        Objects.requireNonNull(auditResource, "auditResource");
        if (auditResource.getId() == null) {
            return auditResource;
        }
        try {
            String uri = this.auditableResourceMapper.map(auditResource.getType(), auditResource.getId()).flatMap(ar -> ar.accept(this.resourceLinkProvider)).orElse(null);
            if (uri == null) {
                log.trace("Couldn't enrich uri for AuditResource: {}", (Object)auditResource);
            }
            return new AuditResource.Builder(auditResource).uri(uri).build();
        }
        catch (RuntimeException e) {
            log.warn("Failed to enrich AuditResource : {}", (Object)auditResource, (Object)e);
            return auditResource;
        }
    }

    private static final class ResourceLinkProvider
    implements AuditableResourceVisitor<Optional<String>> {
        private final NavBuilder navBuilder;
        private final PermissionService permissionService;
        private final ProjectService projectService;
        private final PullRequestService pullRequestService;
        private final RepositoryService repositoryService;
        private final UserService userService;

        private ResourceLinkProvider(NavBuilder navBuilder, PermissionService permissionService, ProjectService projectService, PullRequestService pullRequestService, RepositoryService repositoryService, UserService userService) {
            this.navBuilder = navBuilder;
            this.permissionService = permissionService;
            this.projectService = projectService;
            this.pullRequestService = pullRequestService;
            this.repositoryService = repositoryService;
            this.userService = userService;
        }

        @Override
        @Nonnull
        public Optional<String> visit(@Nonnull AppLinkAuditableResource ignored) {
            return Optional.of(this.navBuilder.admin().appLinks().buildAbsolute());
        }

        @Override
        @Nonnull
        public Optional<String> visit(@Nonnull CommitAuditableResource commitAuditableResource) {
            Objects.requireNonNull(commitAuditableResource, "commitAuditableResource");
            int repositoryId = commitAuditableResource.getRepositoryId();
            if (!this.permissionService.isRepositoryAccessible(repositoryId)) {
                return Optional.empty();
            }
            String commitId = commitAuditableResource.getCommitId();
            Repository repository = this.repositoryService.getById(repositoryId);
            return Optional.ofNullable(repository).map(r -> this.navBuilder.repo(r).commit(commitId).buildAbsolute());
        }

        @Override
        @Nonnull
        public Optional<String> visit(@Nonnull GroupAuditableResource groupAuditableResource) {
            Objects.requireNonNull(groupAuditableResource, "groupAuditableResource");
            if (this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
                return Optional.of(this.navBuilder.admin().groups().view(groupAuditableResource.getGroup()).buildAbsolute());
            }
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Optional<String> visit(@Nonnull ProjectAuditableResource projectAuditableResource) {
            Objects.requireNonNull(projectAuditableResource, "projectAuditableResource");
            int projectId = projectAuditableResource.getId();
            if (!this.permissionService.isProjectAccessible(projectId)) {
                return Optional.empty();
            }
            Project project = this.projectService.getById(projectId);
            return Optional.ofNullable(project).map(p -> (String)p.accept((ProjectVisitor)new ProjectVisitor<String>(){

                public String visit(@Nonnull Project project) {
                    return this.getUrl(project);
                }

                public String visit(@Nonnull PersonalProject project) {
                    return project.getOwner().isActive() ? this.getUrl((Project)project) : null;
                }

                private String getUrl(Project project) {
                    return navBuilder.project(project).buildAbsolute();
                }
            }));
        }

        @Override
        @Nonnull
        public Optional<String> visit(@Nonnull RepositoryAuditableResource repositoryAuditableResource) {
            Objects.requireNonNull(repositoryAuditableResource, "repositoryAuditableResource");
            int repositoryId = repositoryAuditableResource.getId();
            if (!this.permissionService.isRepositoryAccessible(repositoryId)) {
                return Optional.empty();
            }
            Repository repository = this.repositoryService.getById(repositoryId);
            return Optional.ofNullable(repository).map(r -> this.navBuilder.repo(r).buildAbsolute());
        }

        @Override
        @Nonnull
        public Optional<String> visit(@Nonnull PullRequestAuditableResource pullRequestAuditableResource) {
            Objects.requireNonNull(pullRequestAuditableResource, "pullRequestAuditableResource");
            int repositoryId = pullRequestAuditableResource.getRepositoryId();
            if (!this.permissionService.isRepositoryAccessible(repositoryId)) {
                return Optional.empty();
            }
            Long pullRequestId = pullRequestAuditableResource.getPullRequestId();
            if (this.pullRequestService.getById(repositoryId, pullRequestId.longValue()) == null) {
                return Optional.empty();
            }
            Repository repository = this.repositoryService.getById(repositoryId);
            return Optional.ofNullable(repository).map(r -> this.navBuilder.repo(r).pullRequest(pullRequestId.longValue()).buildAbsolute());
        }

        @Override
        @Nonnull
        public Optional<String> visit(@Nonnull UserAuditableResource userAuditableResource) {
            Objects.requireNonNull(userAuditableResource, "userAuditableResource");
            ApplicationUser user = this.userService.getUserById(userAuditableResource.getId());
            return Optional.ofNullable(user).filter(u -> u.getType() == UserType.NORMAL).map(r -> this.navBuilder.user(user).buildAbsolute());
        }

        @Override
        @Nonnull
        public Optional<String> visit(@Nonnull UnknownAuditableResource unknownAuditableResource) {
            Objects.requireNonNull(unknownAuditableResource, "unknownAuditableResource");
            return Optional.empty();
        }
    }
}

