/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.spi.impl.resources;

import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AuditResourceSearchService;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.NoOpAuditResourceSearchService;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.ProjectResourceSearchService;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.PullRequestResourceSearchService;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.RepositoryResourceSearchService;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.RepositoryService;

public class AuditResourceSearchServiceProvider {
    private final NoOpAuditResourceSearchService noOpAuditResourceSearchService;
    private final ProjectResourceSearchService projectResourceSearchService;
    private final PullRequestResourceSearchService pullRequestResourceSearchService;
    private final RepositoryResourceSearchService repositoryResourceSearchService;

    public AuditResourceSearchServiceProvider(ProjectService projectService, PullRequestService pullRequestService, RepositoryService repositoryService) {
        this.projectResourceSearchService = new ProjectResourceSearchService(projectService);
        this.pullRequestResourceSearchService = new PullRequestResourceSearchService(pullRequestService);
        this.repositoryResourceSearchService = new RepositoryResourceSearchService(repositoryService);
        this.noOpAuditResourceSearchService = new NoOpAuditResourceSearchService();
    }

    public AuditResourceSearchService get(String resourceType) {
        switch (resourceType) {
            case "PROJECT": {
                return this.projectResourceSearchService;
            }
            case "PULL_REQUEST": {
                return this.pullRequestResourceSearchService;
            }
            case "REPOSITORY": {
                return this.repositoryResourceSearchService;
            }
        }
        return this.noOpAuditResourceSearchService;
    }
}

