/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.spi.impl.resources;

import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AppLinkAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.CommitAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.GroupAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.ProjectAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.PullRequestAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.RepositoryAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.UnknownAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.UserAuditableResource;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditableResourceMapper {
    private static final Logger log = LoggerFactory.getLogger(AuditableResourceMapper.class);

    @Nonnull
    public Optional<AuditableResource> map(@Nonnull String resourceType, @Nonnull String resourceId) {
        Objects.requireNonNull(resourceType, "resourceType");
        Objects.requireNonNull(resourceId, "resourceId");
        switch (resourceType) {
            case "PULL_REQUEST": {
                return AuditableResourceMapper.getPullRequestResource(resourceType, resourceId);
            }
            case "APPLINK": {
                return Optional.of(new AppLinkAuditableResource());
            }
            case "COMMIT": {
                return AuditableResourceMapper.getCommitResource(resourceType, resourceId);
            }
            case "GROUP": {
                return Optional.of(new GroupAuditableResource(resourceId));
            }
            case "PROJECT": {
                return Optional.ofNullable(StringUtils.isNumeric((CharSequence)resourceId) ? new ProjectAuditableResource(Integer.parseInt(resourceId)) : null);
            }
            case "REPOSITORY": {
                return Optional.ofNullable(StringUtils.isNumeric((CharSequence)resourceId) ? new RepositoryAuditableResource(Integer.parseInt(resourceId)) : null);
            }
            case "USER": {
                return Optional.ofNullable(StringUtils.isNumeric((CharSequence)resourceId) ? new UserAuditableResource(Integer.parseInt(resourceId)) : null);
            }
        }
        return Optional.of(new UnknownAuditableResource());
    }

    private static Optional<AuditableResource> getCommitResource(String resourceType, String resourceId) {
        String[] resourceIds = resourceId.split(":");
        try {
            return Optional.of(new CommitAuditableResource(resourceIds[1], Integer.parseInt(resourceIds[0])));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            log.warn("Cannot map resource id '{}' for resource type '{}'. The format should be repositoryId:commitId", (Object)resourceId, (Object)resourceType);
            return Optional.empty();
        }
    }

    private static Optional<AuditableResource> getPullRequestResource(String resourceType, String resourceId) {
        String[] resourceIds = resourceId.split(":");
        try {
            return Optional.of(new PullRequestAuditableResource(Integer.parseInt(resourceIds[0]), Long.parseLong(resourceIds[1])));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            log.warn("Cannot map resource id '{}' for resource type '{}'. The format should be repositoryId:pullRequestId", (Object)resourceId, (Object)resourceType);
            return Optional.empty();
        }
    }
}

