/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.spi.impl.resources;

import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.api.util.pagination.PageRequest;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.internal.audit.pagination.AuditPaginationUtils;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AuditResourceSearchService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectSearchRequest;
import com.atlassian.bitbucket.project.ProjectService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class ProjectResourceSearchService
implements AuditResourceSearchService {
    private final ProjectService projectService;

    public ProjectResourceSearchService(@Nonnull ProjectService projectService) {
        this.projectService = Objects.requireNonNull(projectService, "projectService");
    }

    @Override
    @Nonnull
    public Page<AuditResource, String> search(@Nullable String text, @Nonnull PageRequest<String> pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        ProjectSearchRequest searchRequest = new ProjectSearchRequest.Builder().name(text).permission(Permission.PROJECT_ADMIN).build();
        com.atlassian.bitbucket.util.Page projectPage = this.projectService.search(searchRequest, AuditPaginationUtils.toBitbucketPageRequest(pageRequest));
        return AuditPaginationUtils.toAuditingPage(projectPage, ProjectResourceSearchService::auditResourceForProject);
    }

    private static AuditResource auditResourceForProject(Project project) {
        return AuditResource.builder((String)project.getName(), (String)"PROJECT").id(String.valueOf(project.getId())).build();
    }
}

