/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.spi.impl.resources;

import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.api.util.pagination.PageRequest;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.internal.audit.pagination.AuditPaginationUtils;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AuditResourceSearchService;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.util.AuditUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class PullRequestResourceSearchService
implements AuditResourceSearchService {
    private final PullRequestService pullRequestService;

    public PullRequestResourceSearchService(@Nonnull PullRequestService pullRequestService) {
        this.pullRequestService = Objects.requireNonNull(pullRequestService, "pullRequestService");
    }

    @Override
    @Nonnull
    public Page<AuditResource, String> search(@Nullable String text, @Nonnull PageRequest<String> pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        PullRequestSearchRequest searchRequest = new PullRequestSearchRequest.Builder().filterText(text).build();
        com.atlassian.bitbucket.util.Page pullRequestPage = this.pullRequestService.search(searchRequest, AuditPaginationUtils.toBitbucketPageRequest(pageRequest));
        return AuditPaginationUtils.toAuditingPage(pullRequestPage, AuditUtils::auditResourceForPullRequest);
    }
}

