/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.spi.impl.resources;

import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.api.util.pagination.PageRequest;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.internal.audit.pagination.AuditPaginationUtils;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AuditResourceSearchService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySearchRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class RepositoryResourceSearchService
implements AuditResourceSearchService {
    private final RepositoryService repositoryService;

    public RepositoryResourceSearchService(@Nonnull RepositoryService repositoryService) {
        this.repositoryService = Objects.requireNonNull(repositoryService, "repositoryService");
    }

    @Override
    @Nonnull
    public Page<AuditResource, String> search(@Nullable String text, @Nonnull PageRequest<String> pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        RepositorySearchRequest searchRequest = new RepositorySearchRequest.Builder().name(text).permission(Permission.REPO_ADMIN).build();
        com.atlassian.bitbucket.util.Page repositoryPage = this.repositoryService.search(searchRequest, AuditPaginationUtils.toBitbucketPageRequest(pageRequest));
        return AuditPaginationUtils.toAuditingPage(repositoryPage, RepositoryResourceSearchService::auditResourceForRepository);
    }

    private static AuditResource auditResourceForRepository(Repository repository) {
        return AuditResource.builder((String)repository.getName(), (String)"REPOSITORY").id(String.valueOf(repository.getId())).build();
    }
}

