/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.audit.spi.impl.security;

import com.atlassian.audit.spi.permission.ResourceContextPermissionChecker;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AppLinkAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AuditableResourceMapper;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.AuditableResourceVisitor;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.CommitAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.GroupAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.ProjectAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.PullRequestAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.RepositoryAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.UnknownAuditableResource;
import com.atlassian.bitbucket.internal.audit.spi.impl.resources.UserAuditableResource;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.RepositoryService;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultResourceContextPermissionChecker
implements ResourceContextPermissionChecker {
    private final AuditableResourceMapper auditableResourceMapper;
    private final ResourcePermissionChecker resourcePermissionChecker;

    public DefaultResourceContextPermissionChecker(AuditableResourceMapper auditableResourceMapper, PermissionService permissionService, ProjectService projectService, RepositoryService repositoryService) {
        this.auditableResourceMapper = auditableResourceMapper;
        this.resourcePermissionChecker = new ResourcePermissionChecker(permissionService, projectService, repositoryService);
    }

    public boolean hasResourceAuditViewPermission(@Nonnull String resourceType, @Nonnull String resourceId) {
        Objects.requireNonNull(resourceType, "resourceType");
        Objects.requireNonNull(resourceId, "resourceId");
        return this.auditableResourceMapper.map(resourceType, resourceId).map(r -> r.accept(this.resourcePermissionChecker)).orElse(true);
    }

    private static final class ResourcePermissionChecker
    implements AuditableResourceVisitor<Boolean> {
        private final PermissionService permissionService;
        private final ProjectService projectService;
        private final RepositoryService repositoryService;

        private ResourcePermissionChecker(PermissionService permissionService, ProjectService projectService, RepositoryService repositoryService) {
            this.permissionService = permissionService;
            this.projectService = projectService;
            this.repositoryService = repositoryService;
        }

        @Override
        @Nonnull
        public Boolean visit(@Nonnull AppLinkAuditableResource ignored) {
            return this.permissionService.hasGlobalPermission(Permission.ADMIN);
        }

        @Override
        @Nonnull
        public Boolean visit(@Nonnull CommitAuditableResource commitAuditableResource) {
            Objects.requireNonNull(commitAuditableResource, "commitAuditableResource");
            return this.canAccessAuditLogsForRepository(commitAuditableResource.getRepositoryId());
        }

        @Override
        @Nonnull
        public Boolean visit(@Nonnull GroupAuditableResource ignored) {
            return this.permissionService.hasGlobalPermission(Permission.ADMIN);
        }

        @Override
        @Nonnull
        public Boolean visit(@Nonnull ProjectAuditableResource projectAuditableResource) {
            Objects.requireNonNull(projectAuditableResource, "projectAuditableResource");
            int projectId = projectAuditableResource.getId();
            return this.permissionService.hasProjectPermission(projectId, Permission.PROJECT_ADMIN) && (this.projectService.getById(projectId) != null || this.permissionService.hasGlobalPermission(Permission.ADMIN));
        }

        @Override
        @Nonnull
        public Boolean visit(@Nonnull RepositoryAuditableResource repositoryAuditableResource) {
            Objects.requireNonNull(repositoryAuditableResource, "repositoryAuditableResource");
            return this.canAccessAuditLogsForRepository(repositoryAuditableResource.getId());
        }

        @Override
        @Nonnull
        public Boolean visit(@Nonnull PullRequestAuditableResource pullRequestAuditableResource) {
            Objects.requireNonNull(pullRequestAuditableResource, "pullRequestAuditableResource");
            return this.canAccessAuditLogsForRepository(pullRequestAuditableResource.getRepositoryId());
        }

        @Override
        @Nonnull
        public Boolean visit(@Nonnull UserAuditableResource ignored) {
            return this.permissionService.hasGlobalPermission(Permission.ADMIN);
        }

        @Override
        @Nonnull
        public Boolean visit(@Nonnull UnknownAuditableResource unknownAuditableResource) {
            Objects.requireNonNull(unknownAuditableResource, "unknownAuditableResource");
            return Boolean.FALSE;
        }

        private boolean canAccessAuditLogsForRepository(int repositoryId) {
            return this.permissionService.hasRepositoryPermission(repositoryId, Permission.REPO_ADMIN) && (this.repositoryService.getById(repositoryId) != null || this.permissionService.hasGlobalPermission(Permission.ADMIN));
        }
    }
}

