/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class AuthenticationResult {
    private final Map<String, Serializable> properties;
    private final ApplicationUser user;

    private AuthenticationResult(Builder builder) {
        this.properties = builder.properties.build();
        this.user = builder.user;
    }

    @Nonnull
    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Serializable> properties;
        private final ApplicationUser user;

        public Builder(@Nonnull ApplicationUser user) {
            this.user = Objects.requireNonNull(user, "user");
            this.properties = ImmutableMap.builder();
        }

        @Nonnull
        public AuthenticationResult build() {
            return new AuthenticationResult(this);
        }

        @Nonnull
        public Builder property(@Nonnull String key, @Nonnull Serializable value) {
            this.properties.put((Object)Objects.requireNonNull(key, "key"), (Object)Objects.requireNonNull(value, "value"));
            return this;
        }

        @Nonnull
        public Builder properties(@Nonnull Map<String, Serializable> values) {
            this.properties.putAll(Objects.requireNonNull(values, "properties"));
            return this;
        }
    }
}

