/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public interface Importer {
    public static final Set<Integer> SUPPORTED_ARCHIVE_VERSIONS = Stream.of(1, 2).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));

    default public void finalizeRepositoryImport(@Nonnull ImportContext context, @Nonnull Repository repository) {
    }

    default public void onArchiveEntry(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        Objects.requireNonNull(importContext, "importContext");
        Objects.requireNonNull(archiveSource, "archiveSource");
        LoggerFactory.getLogger(this.getClass()).warn("Unexpected archive entry on importer that does not support archives: {}", (Object)archiveSource.getPath());
    }

    default public void onEnd(@Nonnull ImportContext importContext) {
    }

    default public void onEntry(@Nonnull ImportContext importContext, @Nonnull EntrySource entrySource) {
        Objects.requireNonNull(importContext, "importContext");
        Objects.requireNonNull(entrySource, "entrySource");
        LoggerFactory.getLogger(this.getClass()).warn("Unexpected entry on importer that does not support entries: {}", (Object)entrySource.getPath());
    }

    default public void onStart(@Nonnull ImportContext importContext) {
    }
}

