/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.migration.MigrationEntityType;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class StandardMigrationEntityType<K>
implements MigrationEntityType<K> {
    public static final MigrationEntityType<Long> ATTACHMENT = new StandardMigrationEntityType<Long>("attachment");
    public static final MigrationEntityType<Long> COMMENT = new StandardMigrationEntityType<Long>("comment");
    public static final MigrationEntityType<Integer> PROJECT = new StandardMigrationEntityType<Integer>("project");
    public static final MigrationEntityType<Integer> REPOSITORY = new StandardMigrationEntityType<Integer>("repository");
    public static final MigrationEntityType<Integer> USER = new StandardMigrationEntityType<Integer>("user");
    private final String name;

    private StandardMigrationEntityType(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public static Optional<MigrationEntityType<?>> ofName(@Nonnull String name) {
        return Arrays.stream(StandardMigrationEntityType.values()).filter(type -> Objects.equals(type.getName(), name)).findAny();
    }

    @Nonnull
    public static Optional<MigrationEntityType<Integer>> ofScope(@Nonnull Scope scope) {
        return (Optional)scope.accept((ScopeVisitor)new ScopeVisitor<Optional<MigrationEntityType<Integer>>>(){

            public Optional<MigrationEntityType<Integer>> visit(@Nonnull RepositoryScope scope) {
                return Optional.of(REPOSITORY);
            }

            public Optional<MigrationEntityType<Integer>> visit(@Nonnull ProjectScope scope) {
                return Optional.of(PROJECT);
            }

            public Optional<MigrationEntityType<Integer>> visit(@Nonnull GlobalScope scope) {
                return Optional.empty();
            }
        });
    }

    @Nonnull
    public static MigrationEntityType<?>[] values() {
        return new MigrationEntityType[]{PROJECT, REPOSITORY, USER};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardMigrationEntityType that = (StandardMigrationEntityType)o;
        return Objects.equals(this.getName(), that.getName());
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

