/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.bitbucket.scm.ScmUrlFormatter;
import com.atlassian.bitbucket.scm.ScmUrlFormatterModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;

public abstract class AbstractScmRequestHandlerModuleDescriptor<T>
extends BaseWeightedModuleDescriptor<T> {
    private String scm;
    private ScmUrlFormatterModuleDescriptor urlFormatterModuleDescriptor;

    public AbstractScmRequestHandlerModuleDescriptor(ModuleFactory moduleFactory, int defaultWeight) {
        super(moduleFactory, defaultWeight);
    }

    @Override
    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.scm = element.attributeValue("scm");
        Element urlFormatterElement = element.element("url-formatter");
        if (urlFormatterElement != null) {
            this.urlFormatterModuleDescriptor = new ScmUrlFormatterModuleDescriptor(this.moduleFactory);
            this.urlFormatterModuleDescriptor.init(plugin, urlFormatterElement);
        }
    }

    @Nonnull
    public T getModule() {
        return (T)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    @Nullable
    public String getScm() {
        return this.scm;
    }

    @Nullable
    public ScmUrlFormatter getUrlFormatter() {
        return this.urlFormatterModuleDescriptor == null ? null : this.urlFormatterModuleDescriptor.getModule();
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("class") == null) {
            throw new ValidationException(List.of("The ssh-request-handler class attribute is required"));
        }
    }
}

