/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.util.Weighted;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import jakarta.annotation.Nonnull;

public abstract class BaseWeightedModuleDescriptor<T>
extends AbstractModuleDescriptor<T>
implements Weighted,
Comparable<BaseWeightedModuleDescriptor<T>> {
    private int weight;

    public BaseWeightedModuleDescriptor(ModuleFactory moduleFactory, int defaultWeight) {
        super(moduleFactory);
        this.weight = defaultWeight;
    }

    @Override
    public int compareTo(@Nonnull BaseWeightedModuleDescriptor<T> otherDescriptor) {
        return Weighted.COMPARABLE.compare(this, otherDescriptor);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        String weightAttr = element.attributeValue("weight");
        if (weightAttr != null) {
            try {
                this.weight = Integer.parseInt(weightAttr);
            }
            catch (NumberFormatException e) {
                throw new PluginParseException("The 'weight' attribute must be a number.", (Throwable)e);
            }
        }
    }
}

