/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class DeleteCommandParameters
extends AbstractCommandParameters {
    private final Set<Integer> forkIds;
    private final boolean lastForkOfOrigin;
    private final boolean lastInHierarchy;

    private DeleteCommandParameters(Builder builder) {
        this.forkIds = (Set)Objects.requireNonNull(builder.forkIds.build(), "forkIds");
        this.lastForkOfOrigin = builder.lastForkOfOrigin;
        this.lastInHierarchy = builder.lastInHierarchy;
        if (this.lastInHierarchy) {
            Preconditions.checkArgument((boolean)this.forkIds.isEmpty(), (Object)"A repository cannot have forks and be the last in its hierarchy");
        }
    }

    @Nonnull
    public Set<Integer> getForkIds() {
        return this.forkIds;
    }

    public boolean hasForks() {
        return !this.forkIds.isEmpty();
    }

    public boolean isLastForkOfOrigin() {
        return this.lastForkOfOrigin;
    }

    public boolean isLastInHierarchy() {
        return this.lastInHierarchy;
    }

    public static class Builder {
        private ImmutableSet.Builder<Integer> forkIds = ImmutableSet.builder();
        private boolean lastForkOfOrigin;
        private boolean lastInHierarchy;

        public DeleteCommandParameters build() {
            return new DeleteCommandParameters(this);
        }

        public Builder forkIds(@Nonnull Iterable<Integer> value) {
            this.forkIds.addAll(value);
            return this;
        }

        public Builder lastForkOfOrigin() {
            this.lastForkOfOrigin = true;
            return this;
        }

        public Builder lastInHierarchy() {
            this.lastInHierarchy = true;
            return this;
        }
    }
}

