/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.http;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;

public class HttpRequestDetails {
    private final HttpServletRequest request;

    private HttpRequestDetails(HttpServletRequest request) {
        this.request = request;
    }

    public static HttpRequestDetails ofServletRequest(HttpServletRequest request) {
        return new HttpRequestDetails(request);
    }

    @Nullable
    public String getContentType() {
        return this.request.getContentType();
    }

    @Nullable
    public String getHeader(@Nonnull String name) {
        return this.request.getHeader(Objects.requireNonNull(name));
    }

    @Nonnull
    public String getMethod() {
        return this.request.getMethod();
    }

    @Nullable
    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    @Nullable
    public String getParameter(@Nonnull String name) {
        return this.request.getParameter(Objects.requireNonNull(name));
    }
}

