/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.http;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RepositoryUrlFragment {
    private static final String SHORT_HOSTING_URL = "/?(?<projKey>[^/]+)/(?<repoSlug>[^/]+?)(?:\\.git)?+(?<restOfPath>/.*|$)";
    private static final String NAMESPACED_HOSTING_URL = "/?(?<namespace>[^/]+)/?(?<projKey>[^/]+)/(?<repoSlug>[^/]+?)(?:\\.git)?+(?<restOfPath>/.*|$)";
    private static final Pattern PATTERN_SHORT_HOSTING_URL = Pattern.compile("/?(?<projKey>[^/]+)/(?<repoSlug>[^/]+?)(?:\\.git)?+(?<restOfPath>/.*|$)");
    private static final Pattern PATTERN_NAMESPACED_HOSTING_URL = Pattern.compile("/?(?<namespace>[^/]+)/?(?<projKey>[^/]+)/(?<repoSlug>[^/]+?)(?:\\.git)?+(?<restOfPath>/.*|$)");
    private final String pathSuffix;
    private final String projectNamespace;
    private final String projectKey;
    private final String repositorySlug;

    private RepositoryUrlFragment(String projectKey, String repositorySlug, String pathSuffix) {
        this.pathSuffix = StringUtils.trimToNull((String)pathSuffix);
        this.projectNamespace = null;
        this.projectKey = Objects.requireNonNull(projectKey, "projectKey");
        this.repositorySlug = Objects.requireNonNull(repositorySlug, "repositorySlug");
    }

    @Nullable
    public static RepositoryUrlFragment fromPathInfo(@Nonnull String pathInfo) {
        Matcher m = PATTERN_SHORT_HOSTING_URL.matcher(Objects.requireNonNull(pathInfo, "pathInfo"));
        return m.find() ? new RepositoryUrlFragment(m.group("projKey"), m.group("repoSlug"), m.group("restOfPath")) : null;
    }

    @Deprecated
    @Nullable
    public static RepositoryUrlFragment fromNamespacedPathInfo(@Nonnull String pathInfo) {
        Matcher m = PATTERN_NAMESPACED_HOSTING_URL.matcher(Objects.requireNonNull(pathInfo, "pathInfo"));
        return m.find() ? new RepositoryUrlFragment(m.group("projKey"), m.group("repoSlug"), m.group("restOfPath")) : null;
    }

    @Nonnull
    public static RepositoryUrlFragment fromRepository(@Nonnull Repository repository) {
        Project project = Objects.requireNonNull(repository, "repository").getProject();
        String projectKey = project.getKey();
        return new RepositoryUrlFragment(projectKey, repository.getSlug(), null);
    }

    @Nonnull
    public static RepositoryUrlFragment fromKeyAndSlug(@Nonnull String projectKey, @Nonnull String repositorySlug) {
        Objects.requireNonNull(projectKey, "projectKey");
        Objects.requireNonNull(repositorySlug, "repositorySlug");
        return new RepositoryUrlFragment(projectKey, repositorySlug, null);
    }

    @Nullable
    public String getPathSuffix() {
        return this.pathSuffix;
    }

    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nonnull
    public String getRepositorySlug() {
        return this.repositorySlug;
    }

    @Nonnull
    public String toPath(@Nullable String basePath) {
        return this.toPath(basePath, false);
    }

    @Nonnull
    public String toPath(@Nullable String basePath, boolean includeSuffix) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)basePath)) {
            builder.append('/');
        } else {
            builder.append(basePath);
            if (!basePath.endsWith("/")) {
                builder.append('/');
            }
        }
        return builder.append(this.toPath(includeSuffix)).toString();
    }

    @Nonnull
    public String toString() {
        return this.toPath(null, false);
    }

    private String toPath(boolean includeSuffix) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.projectKey).append('/').append(this.repositorySlug);
        if (includeSuffix && StringUtils.isNotEmpty((CharSequence)this.pathSuffix)) {
            builder.append('/').append(this.pathSuffix);
        }
        return builder.toString().toLowerCase(Locale.ROOT);
    }
}

