/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeResult;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.SimpleCommand;
import com.atlassian.bitbucket.scm.pull.BulkRescopeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestAcceptMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestChangesCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestCommitsCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDeleteCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.scm.pull.PullRequestMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestPrepareMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.UpdatePullRequestRefsCommandParameters;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PluginPullRequestCommandFactory {
    @Nonnull
    public Command<Branch> acceptMerge(@Nonnull PullRequest var1, @Nonnull PullRequestAcceptMergeCommandParameters var2);

    @Nonnull
    public Command<Void> bulkRescope(@Nonnull BulkRescopeCommandParameters var1);

    @Nonnull
    public Command<Void> changes(@Nonnull PullRequest var1, @Nonnull PullRequestChangesCommandParameters var2, @Nonnull ChangeCallback var3);

    @Nonnull
    public Command<Void> commits(@Nonnull PullRequest var1, @Nonnull PullRequestCommitsCommandParameters var2, @Nonnull CommitCallback var3);

    @Nonnull
    default public Command<Void> delete(@Nonnull PullRequest pullRequest, @Nonnull PullRequestDeleteCommandParameters parameters) {
        return new SimpleCommand<Void>(this){

            public Void call() {
                return null;
            }
        };
    }

    @Nonnull
    default public Command<Void> delete(@Nonnull Repository repository, long pullRequestId, @Nonnull PullRequestDeleteCommandParameters parameters) {
        return new SimpleCommand<Void>(this){

            public Void call() {
                return null;
            }
        };
    }

    @Nonnull
    public Command<Void> diff(@Nonnull PullRequest var1, @Nonnull PullRequestDiffCommandParameters var2, @Nonnull DiffContentCallback var3);

    @Nonnull
    public Command<DiffStatsSummary> diffStatsSummary(@Nonnull PullRequest var1, @Nonnull PullRequestDiffStatsSummaryCommandParameters var2);

    @Nonnull
    public Command<PullRequestEffectiveDiff> effectiveDiff(@Nonnull PullRequest var1);

    @Nonnull
    public Command<Branch> merge(@Nonnull PullRequest var1, @Nonnull PullRequestMergeCommandParameters var2);

    @Nonnull
    public Command<Branch> prepareMerge(@Nonnull PullRequest var1, @Nonnull PullRequestPrepareMergeCommandParameters var2);

    @Nonnull
    public Command<PullRequestMergeResult> tryMerge(@Nonnull PullRequest var1);

    @Nonnull
    default public Command<Void> updateRefs(final @Nonnull UpdatePullRequestRefsCommandParameters parameters) {
        final Logger log = LoggerFactory.getLogger(this.getClass());
        return new SimpleCommand<Void>(this){

            public Void call() {
                String scmId = Objects.requireNonNull(parameters, "parameters").getPullRequests().stream().map(pullRequest -> pullRequest.getToRef().getRepository().getScmId()).findFirst().orElse("unknown");
                log.debug("PluginPullRequestCommandFactory.updateRefs is not implemented for SCM {}", (Object)scmId);
                return null;
            }
        };
    }
}

