/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.ssh;

import com.atlassian.bitbucket.scm.ssh.ExitCodeCallback;
import com.atlassian.bitbucket.ssh.command.SshCommandContext;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;

public class SshScmRequestContext
implements ExitCodeCallback {
    private final String command;
    private final Map<String, String> environment;
    private final ExitCodeCallback exitCodeCallback;
    private final OutputStream stderr;
    private final InputStream stdin;
    private final OutputStream stdout;

    private SshScmRequestContext(Builder builder) {
        this.command = builder.command;
        this.environment = builder.environment.build();
        this.exitCodeCallback = builder.exitCodeCallback;
        this.stderr = builder.stderr;
        this.stdin = builder.stdin;
        this.stdout = builder.stdout;
    }

    @Nonnull
    public String getCommand() {
        return this.command;
    }

    @Nonnull
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Nonnull
    public ExitCodeCallback getExitCodeCallback() {
        return this.exitCodeCallback;
    }

    @Nonnull
    public OutputStream getStderr() {
        return this.stderr;
    }

    @Nonnull
    public InputStream getStdin() {
        return this.stdin;
    }

    @Nonnull
    public OutputStream getStdout() {
        return this.stdout;
    }

    @Override
    public void onExit(int code) {
        this.exitCodeCallback.onExit(code);
    }

    public static class Builder
    extends BuilderSupport {
        private final String command;
        private final ImmutableMap.Builder<String, String> environment;
        private ExitCodeCallback exitCodeCallback;
        private OutputStream stderr;
        private InputStream stdin;
        private OutputStream stdout;

        public Builder(@Nonnull SshCommandContext context, @Nonnull ExitCodeCallback exitCodeCallback) {
            this(Objects.requireNonNull(context, "context").getCommand(), context.getStdin(), context.getStdout(), context.getStderr(), exitCodeCallback);
            this.environment.putAll(context.getEnvironment());
        }

        public Builder(@Nonnull SshScmRequestContext context) {
            this(Objects.requireNonNull(context, "context").getCommand(), context.getStdin(), context.getStdout(), context.getStderr(), context.getExitCodeCallback());
            this.environment.putAll(context.getEnvironment());
        }

        public Builder(@Nonnull String command, @Nonnull InputStream stdin, @Nonnull OutputStream stdout, @Nonnull OutputStream stderr, @Nonnull ExitCodeCallback exitCodeCallback) {
            this.command = Builder.requireNonBlank((String)command, (String)"command");
            this.exitCodeCallback = Objects.requireNonNull(exitCodeCallback, "exitCodeCallback");
            this.stderr = Objects.requireNonNull(stderr, "stderr");
            this.stdin = Objects.requireNonNull(stdin, "stdin");
            this.stdout = Objects.requireNonNull(stdout, "stdout");
            this.environment = ImmutableMap.builder();
        }

        @Nonnull
        public SshScmRequestContext build() {
            return new SshScmRequestContext(this);
        }

        @Nonnull
        public Builder environment(@Nonnull Map<String, String> values) {
            this.environment.putAll(Objects.requireNonNull(values, "environment"));
            return this;
        }

        @Nonnull
        public Builder environment(@Nonnull String key, @Nonnull String value) {
            this.environment.put((Object)Builder.requireNonBlank((String)key, (String)"key"), (Object)Builder.requireNonBlank((String)value, (String)"value"));
            return this;
        }

        @Nonnull
        public Builder exitCodeCallback(@Nonnull ExitCodeCallback value) {
            this.exitCodeCallback = Objects.requireNonNull(value, "exitCodeCallback");
            return this;
        }

        @Nonnull
        public Builder stderr(@Nonnull OutputStream value) {
            this.stderr = Objects.requireNonNull(value, "stderr");
            return this;
        }

        @Nonnull
        public Builder stdin(@Nonnull InputStream value) {
            this.stdin = Objects.requireNonNull(value, "stdin");
            return this;
        }

        @Nonnull
        public Builder stdout(@Nonnull OutputStream value) {
            this.stdout = Objects.requireNonNull(value, "stdout");
            return this;
        }
    }
}

