/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.settingsrestriction;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class RestrictionProcessingRequest {
    private final Set<Repository> repositories;
    private final SettingsKey settingsKey;

    public RestrictionProcessingRequest(@Nonnull Set<Repository> repositories, @Nonnull SettingsKey settingsKey) {
        this.repositories = Objects.requireNonNull(repositories, "repositories");
        this.settingsKey = Objects.requireNonNull(settingsKey, "settingsKey");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictionProcessingRequest that = (RestrictionProcessingRequest)o;
        return this.repositories.equals(that.repositories) && this.settingsKey.equals((Object)that.settingsKey);
    }

    @Nonnull
    public Set<Repository> getRepositories() {
        return this.repositories;
    }

    @Nonnull
    public SettingsKey getSettingsKey() {
        return this.settingsKey;
    }

    public int hashCode() {
        return Objects.hash(this.repositories, this.settingsKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("settingsKey", (Object)this.settingsKey).add("batchSize", this.repositories.size()).toString();
    }
}

