/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ssh.command;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;

public class SshCommandContext {
    private final String command;
    private final Map<String, String> environment;
    private final OutputStream stderr;
    private final InputStream stdin;
    private final OutputStream stdout;

    private SshCommandContext(Builder builder) {
        this.command = builder.command;
        this.environment = builder.environment.build();
        this.stderr = builder.stderr;
        this.stdin = builder.stdin;
        this.stdout = builder.stdout;
    }

    @Nonnull
    public String getCommand() {
        return this.command;
    }

    @Nonnull
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Nonnull
    public OutputStream getStderr() {
        return this.stderr;
    }

    @Nonnull
    public InputStream getStdin() {
        return this.stdin;
    }

    @Nonnull
    public OutputStream getStdout() {
        return this.stdout;
    }

    public static class Builder
    extends BuilderSupport {
        private final String command;
        private final ImmutableMap.Builder<String, String> environment;
        private final OutputStream stderr;
        private final InputStream stdin;
        private final OutputStream stdout;

        public Builder(@Nonnull String command, @Nonnull InputStream stdin, @Nonnull OutputStream stdout, @Nonnull OutputStream stderr) {
            this.command = Builder.requireNonBlank((String)command, (String)"command");
            this.stderr = Objects.requireNonNull(stderr, "stderr");
            this.stdin = Objects.requireNonNull(stdin, "stdin");
            this.stdout = Objects.requireNonNull(stdout, "stdout");
            this.environment = ImmutableMap.builder();
        }

        @Nonnull
        public SshCommandContext build() {
            return new SshCommandContext(this);
        }

        @Nonnull
        public Builder environment(@Nonnull Map<String, String> values) {
            this.environment.putAll(Objects.requireNonNull(values, "environment"));
            return this;
        }

        @Nonnull
        public Builder environment(@Nonnull String key, @Nonnull String value) {
            this.environment.put((Object)Builder.requireNonBlank((String)key, (String)"key"), (Object)Builder.requireNonBlank((String)value, (String)"value"));
            return this;
        }
    }
}

