/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.policies.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.policy.DmzPolicyService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.policies.rest.RestRepositoryPolicy;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="admin")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
public class PolicyResource {
    private final DmzPolicyService policyService;
    private final I18nService i18nService;

    @Inject
    public PolicyResource(DmzPolicyService policyService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.policyService = policyService;
    }

    @Operation(description="Retrieves the repository archive policy for the instance.\n\nThe user must be authenticated to access this resource.", summary="Get repository archive policy")
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the repository archive policy for the instance", representation=RestRepositoryPolicy.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the repository archive policy", responseCode=401, restError=true)})
    @GET
    @Path(value="/repos/archive")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepositoryArchivePolicy() {
        return ResponseFactory.ok((Object)((Object)new RestRepositoryPolicy(this.policyService.getRepositoryArchivePolicy().name()))).build();
    }

    @Operation(description="Sets the repository archive policy for the instance.\n\nThe authenticated user must have <b>SYS_ADMIN</b> permission.", summary="Update repository archive policy")
    @RequestBody(description="The request containing the details of the policy.", content={@Content(schema=@Schema(implementation=RestRepositoryPolicy.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the repository archive policy for the instance", representation=RestRepositoryPolicy.class, responseCode=200), @ResponseDoc(documentation="The permission was invalid or does not exist", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to set the repository archive policy", responseCode=401, restError=true)})
    @PUT
    @Path(value="/repos/archive")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setRepositoryArchivePolicy(RestRepositoryPolicy policy) {
        try {
            Permission permission = Permission.valueOf((String)policy.getPermission());
            this.policyService.setRepositoryArchivePolicy(permission);
            return ResponseFactory.ok((Object)((Object)new RestRepositoryPolicy(this.policyService.getRepositoryArchivePolicy().name()))).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)this.i18nService.getMessage("bitbucket.rest.policies.invalid.repo.archive.permission", new Object[0])).build();
        }
    }

    @Operation(description="Retrieves the repository delete policy for the instance.\n\nThe user must be authenticated to access this resource.", summary="Get repository delete policy")
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the repository delete policy for the instance", representation=RestRepositoryPolicy.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the repository delete policy", responseCode=401, restError=true)})
    @GET
    @Path(value="/repos/delete")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepositoryDeletePolicy() {
        return ResponseFactory.ok((Object)((Object)new RestRepositoryPolicy(this.policyService.getRepositoryDeletePolicy().name()))).build();
    }

    @Operation(description="Sets the repository delete policy for the instance.\n\nThe authenticated user must have <b>SYS_ADMIN</b> permission.", summary="Update the repository delete policy")
    @RequestBody(description="The request containing the details of the policy.", content={@Content(schema=@Schema(implementation=RestRepositoryPolicy.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the repository delete policy for the instance", representation=RestRepositoryPolicy.class, responseCode=200), @ResponseDoc(documentation="The permission was invalid or does not exist", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to set the repository delete policy", responseCode=401, restError=true)})
    @PUT
    @Path(value="/repos/delete")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setRepositoryDeletePolicy(RestRepositoryPolicy policy) {
        try {
            Permission permission = Permission.valueOf((String)policy.getPermission());
            this.policyService.setRepositoryDeletePolicy(permission);
            return ResponseFactory.ok((Object)((Object)new RestRepositoryPolicy(this.policyService.getRepositoryDeletePolicy().name()))).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)this.i18nService.getMessage("bitbucket.rest.policies.invalid.repo.delete.permission", new Object[0])).build();
        }
    }
}

