/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.info;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.bitbucket.plugin.OptionalPluginInformationProvider;
import org.eclipse.gemini.blueprint.context.BundleContextAware;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DefaultPluginInformationProvider
implements BundleContextAware,
DisposableBean,
OptionalPluginInformationProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginInformationProvider.class);
    private ServiceTracker<?, ?> serviceTracker;

    public boolean canCollectAnalytics() {
        if (this.serviceTracker == null) {
            log.warn("serviceTracker is unexpectedly null");
            return false;
        }
        AnalyticsConfigService analyticsConfigService = (AnalyticsConfigService)this.serviceTracker.getService();
        if (analyticsConfigService != null) {
            return analyticsConfigService.canCollectAnalytics();
        }
        log.debug("No instance of the analyticsConfigService was found.");
        return false;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.serviceTracker = new ServiceTracker(bundleContext, AnalyticsConfigService.class.getName(), null);
        this.serviceTracker.open();
    }

    public void destroy() {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
        }
    }
}

