/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.chaperone.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.chaperone.ChaperonePinManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;

@Path(value="chaperone")
public class ChaperoneResource {
    private static final CacheControl NO_CACHE = ChaperoneResource.getNoCache();
    private ChaperonePinManager pinManager;

    @Inject
    public ChaperoneResource(ChaperonePinManager pinManager) {
        this.pinManager = pinManager;
    }

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPins(@PathParam(value="key") String key) {
        if (this.pinManager.getValue(key) != null) {
            return Response.ok((Object)this.pinManager.getValue(key)).cacheControl(NO_CACHE).build();
        }
        return Response.noContent().cacheControl(NO_CACHE).build();
    }

    @PUT
    @Path(value="{key}")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response putPins(@PathParam(value="key") String key, @FormParam(value="json") String json) {
        this.pinManager.setValue(key, json);
        return Response.ok().cacheControl(NO_CACHE).build();
    }

    private static CacheControl getNoCache() {
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        return cc;
    }
}

